/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.fileSystem.file.FileDownloader;
import com.gamedash.daemon.system.ArchitectureEnum;
import com.gamedash.daemon.system.OperatingSystem;
import com.gamedash.daemon.windows.WindowsBridge;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

public class WindowsBridgeDependency
implements IDependency {
    @Override
    public void install() throws Exception {
        FileDownloader fileDownloader = new FileDownloader(this.getFile(), new URL("https://download.gamedash.io/daemon/dependency/versions/1/WindowsBridge-x64.dll"));
        fileDownloader.download();
    }

    @Override
    public void uninstall() {
        this.getFile().delete();
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_WINDOWS && (OperatingSystem.getArchitecture() == ArchitectureEnum.x64 || OperatingSystem.getArchitecture() == ArchitectureEnum.x86);
    }

    private File getFile() {
        return WindowsBridge.getDllFile();
    }
}

