/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.fileSystem.file.FileDownloader;
import com.gamedash.daemon.system.ArchitectureEnum;
import com.gamedash.daemon.system.OperatingSystem;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

public class ProcessUsageDependency
implements IDependency {
    @Override
    public void install() throws Exception {
        URL url = SystemUtils.IS_OS_WINDOWS ? new URL("https://download.gamedash.io/daemon/dependency/versions/1/ProcessUsage-Windows.exe") : new URL("https://download.gamedash.io/daemon/dependency/versions/1/ProcessUsage-Linux");
        FileDownloader fileDownloader = new FileDownloader(ProcessUsageDependency.getFile(), url);
        fileDownloader.download();
    }

    @Override
    public void uninstall() {
        ProcessUsageDependency.getFile().delete();
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_WINDOWS && (OperatingSystem.getArchitecture() == ArchitectureEnum.x64 || OperatingSystem.getArchitecture() == ArchitectureEnum.x86);
    }

    public static File getFile() {
        String fileName = SystemUtils.IS_OS_WINDOWS ? "ProcessUsage-Windows.exe" : "ProcessUsage-Linux";
        return new File(FileSystemHelpers.getOwnDirectory(ProcessUsageDependency.class).getAbsolutePath() + File.separator + fileName);
    }
}

