/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.IDependency;

public class Dependency {
    private Class<? extends IDependency> dependencyClass;
    private IDependency instance;

    public Dependency(Class<? extends IDependency> dependencyClass) {
        this.dependencyClass = dependencyClass;
    }

    public String getName() {
        return this.getDependencyClass().getName();
    }

    public Class<? extends IDependency> getDependencyClass() {
        return this.dependencyClass;
    }

    public void install() throws Exception {
        if (this.isInstalled()) {
            throw new Exception(String.format("Dependency %s is already installed", this.getName()));
        }
        this.createInstance().install();
        Dependencies.addInstalled(this);
    }

    public void uninstall() throws Exception {
        if (!this.isInstalled()) {
            throw new Exception(String.format("Dependency %s is not installed", this.getName()));
        }
        this.createInstance().uninstall();
        Dependencies.removeInstalled(this);
    }

    public boolean isInstalled() throws Exception {
        for (Dependency dependency : Dependencies.getInstalled()) {
            if (!dependency.getName().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    private IDependency createInstance() throws Exception {
        if (this.instance == null) {
            this.instance = this.dependencyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.instance;
    }
}

