/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.dependency.Dependency;
import com.gamedash.daemon.dependency.ProcessUsageDependency;
import com.gamedash.daemon.dependency.WindowsBridgeDependency;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Dependencies {
    private static List<Dependency> dependencies;

    public static List<Dependency> getAll() {
        if (dependencies == null) {
            ArrayList<Class> dependencyClasses = new ArrayList<Class>();
            dependencyClasses.add(WindowsBridgeDependency.class);
            dependencyClasses.add(ProcessUsageDependency.class);
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            for (Class dependencyClass : dependencyClasses) {
                dependencies.add(new Dependency(dependencyClass));
            }
            Dependencies.dependencies = dependencies;
        }
        return dependencies;
    }

    public static Dependency get(String name) {
        for (Dependency dependency : Dependencies.getAll()) {
            if (!dependency.getName().equals(name)) continue;
            return dependency;
        }
        return null;
    }

    public static void install() throws Exception {
        for (Dependency dependency : Dependencies.getAll()) {
            if (dependency.isInstalled()) continue;
            dependency.install();
        }
    }

    public static List<Dependency> getInstalled() throws Exception {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (Config.getFile("daemon.properties").valueExists("dependencies")) {
            for (String name : Config.getFile("daemon.properties").getValueAsList("dependencies")) {
                Dependency dependency = Dependencies.get(name);
                if (dependency == null) continue;
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    public static synchronized void addInstalled(Dependency dependency) throws Exception {
        List<Dependency> dependencies = Dependencies.getInstalled();
        dependencies.add(dependency);
        Dependencies.setInstalled(dependencies);
    }

    public static void removeInstalled(Dependency dependency) throws Exception {
        List<Dependency> dependencies = Dependencies.getInstalled().stream().filter(_dependency -> _dependency.getName().equals(dependency.getName())).collect(Collectors.toList());
        Dependencies.setInstalled(dependencies);
    }

    private static void setInstalled(List<Dependency> dependencies) throws Exception {
        List versionIds = dependencies.stream().map(Dependency::getName).collect(Collectors.toList());
        Config.getFile("daemon.properties").setValue("dependencies", versionIds);
    }
}

