/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.ResponseFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import spark.Request;
import spark.Response;

public class GetContents
extends Route<List<ResponseFile>> {
    public GetContents(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ResponseFile> execute() throws Exception {
        com.gamedash.daemon.fileSystem.File directory = com.gamedash.daemon.fileSystem.File.fromBase64(this.getParameters().get("path").getValue());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        List<File> files = this.getFiles(directory);
        ArrayList<ResponseFile> responseFiles = new ArrayList<ResponseFile>();
        for (File file : files) {
            if (file.toPath().compareTo(directory.toPath()) == 0) continue;
            responseFiles.add(new ResponseFile(directory, file));
        }
        return responseFiles;
    }

    protected List<File> getFiles(final File directory) {
        return (List)FileUtils.listFilesAndDirs(directory, new IOFileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getParentFile().toPath().compareTo(directory.toPath()) == 0;
            }

            @Override
            public boolean accept(File dir, String name) {
                return false;
            }
        }, new IOFileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getParentFile().toPath().compareTo(directory.toPath()) == 0;
            }

            @Override
            public boolean accept(File dir, String name) {
                return false;
            }
        });
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

