/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.FileNotFoundException;
import org.apache.commons.io.FileUtils;
import spark.Request;
import spark.Response;

public class Copy
extends Route<String> {
    public Copy(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = File.fromBase64(this.getParameters().get("origin").getValue());
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        if (destination.exists() && !destination.isDirectory()) {
            throw new FileNotFoundException("Destination file already exists, but is not a directory");
        }
        FileUtils.copyDirectory(origin, destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

