/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.schokkerit.restapi.client.ApiException;
import com.schokkerit.restapi.client.QueryResponse;
import com.schokkerit.restapi.client.enums.HttpProtocolsEnum;
import com.schokkerit.restapi.client.header.Header;
import com.schokkerit.restapi.client.header.Headers;
import com.schokkerit.restapi.client.parameter.Parameter;
import com.schokkerit.restapi.client.parameter.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiQuery {
    protected CloseableHttpClient httpClient = this.createClient();
    private static Logger logger = LoggerFactory.getLogger(ApiQuery.class);
    private String endpoint;
    private Headers headers = new Headers();
    private Parameters parameters = new Parameters();
    private boolean hasExecuted = false;
    private boolean shouldHandleResponse = true;

    public ApiQuery(String endpoint) throws Exception {
        this.endpoint = endpoint;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public QueryResponse delete() throws Exception {
        URIBuilder builder = new URIBuilder(this.getAddress());
        for (Parameter parameter : this.getParameters().getAll()) {
            builder.addParameter(parameter.getName(), parameter.toString());
        }
        return this.makeRequest(new HttpDelete(builder.build()));
    }

    public QueryResponse put() throws Exception {
        HttpPut httpPut = new HttpPut(this.getAddress());
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Parameter parameter : this.getParameters().getAll()) {
            parameters.add(new BasicNameValuePair(parameter.getName(), parameter.toString()));
        }
        httpPut.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        return this.makeRequest(httpPut);
    }

    public QueryResponse post() throws Exception {
        HttpPost httpPost = new HttpPost(this.getAddress());
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Parameter parameter : this.getParameters().getAll()) {
            parameters.add(new BasicNameValuePair(parameter.getName(), parameter.toString()));
        }
        httpPost.setEntity(new UrlEncodedFormEntity(parameters, "UTF-8"));
        return this.makeRequest(httpPost);
    }

    public QueryResponse get() throws Exception {
        URIBuilder builder = new URIBuilder(this.getAddress());
        for (Parameter parameter : this.getParameters().getAll()) {
            builder.addParameter(parameter.getName(), parameter.toString());
        }
        return this.makeRequest(new HttpGet(builder.build()));
    }

    public boolean shouldHandleResponse() {
        return this.shouldHandleResponse;
    }

    public void setShouldHandleResponse(boolean shouldHandleResponse) {
        this.shouldHandleResponse = shouldHandleResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResponse makeRequest(HttpRequestBase httpMethod) throws Exception {
        if (this.hasExecuted) {
            throw new ApiException("Api query has already been executed");
        }
        try {
            for (Header header : this.getHeaders().getAll()) {
                httpMethod.addHeader(header.getName(), header.toString());
            }
            ResponseHandler<QueryResponse> responseHandler = this.shouldHandleResponse() ? response -> {
                JsonObject jsonObject;
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                String rawResponse = EntityUtils.toString(entity);
                JsonObject jsonObject2 = jsonObject = !rawResponse.equals("") ? new JsonParser().parse(rawResponse).getAsJsonObject() : null;
                if (statusCode >= 300 || statusCode < 200) {
                    logger.info(jsonObject.toString());
                    throw new ApiException(jsonObject.get("error").getAsJsonObject().get("status").getAsString());
                }
                return new QueryResponse(jsonObject, statusCode);
            } : response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                String rawResponse = EntityUtils.toString(entity);
                JsonObject jsonObject = !rawResponse.equals("") ? new JsonParser().parse(rawResponse).getAsJsonObject() : null;
                return new QueryResponse(jsonObject, statusCode);
            };
            logger.info("Sending " + httpMethod.toString() + " to " + this.getAddress());
            QueryResponse queryResponse = this.httpClient.execute((HttpUriRequest)httpMethod, responseHandler);
            return queryResponse;
        }
        finally {
            this.httpClient.close();
            this.hasExecuted = true;
        }
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected abstract String getAddress() throws Exception;

    protected HttpProtocolsEnum getProtocol() throws Exception {
        return this.isSecure() != false ? HttpProtocolsEnum.https : HttpProtocolsEnum.http;
    }

    protected abstract Boolean isSecure() throws Exception;

    protected CloseableHttpClient createClient() throws Exception {
        return HttpClients.createDefault();
    }
}

