/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.shutdown;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.fileSystem.ftp.server.FtpServer;
import com.gamedash.daemon.infrastructure.node.Nodes;
import com.gamedash.daemon.installer.Installer;
import com.gamedash.daemon.process.childprocess.ChildProcesses;
import com.gamedash.daemon.relay.server.RelayServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdown {
    private static Logger logger = LoggerFactory.getLogger(Shutdown.class);
    private static boolean isShuttingDown = false;

    public static void registerHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            block2: {
                logger.info("Shutting down");
                try {
                    Shutdown.run();
                }
                catch (Exception e) {
                    if (!DevelopmentMode.isEnabled()) break block2;
                    logger.error(e.getMessage());
                }
            }
        }));
    }

    public static void run() throws Exception {
        FtpServer ftpServer;
        if (Shutdown.isShuttingDown()) {
            return;
        }
        Shutdown.setIsShuttingDown(true);
        ChildProcesses.stopAll();
        if (RelayServer.hasStarted()) {
            RelayServer.stop();
        }
        if ((ftpServer = FtpServer.getInstance()).isRunning()) {
            ftpServer.stop();
        }
        if (ApiServer.isRunning().booleanValue()) {
            ApiServer.stop();
        }
        if (Installer.getState() == InstallerStateEnum.inProgress) {
            Installer.setState(InstallerStateEnum.notInstalled);
        }
        Nodes.getSelf().getStatus().update(false);
    }

    public static boolean isShuttingDown() {
        return isShuttingDown;
    }

    private static void setIsShuttingDown(boolean isShuttingDown) {
        Shutdown.isShuttingDown = isShuttingDown;
    }
}

