/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.terminal.windows;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.terminal.ITerminal;
import com.gamedash.daemon.process.childprocess.terminal.io.IIo;
import com.gamedash.daemon.process.childprocess.terminal.windows.Io;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcess;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcessUser;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcesses;
import java.io.IOException;
import java.util.Arrays;

public class Windows
implements ITerminal {
    private ChildProcess childProcess;
    private WindowsChildProcess windowsChildProcess;
    private SystemUser systemUser;
    private IIo io;

    public Windows(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] inputArgs) throws Exception {
        String executable = inputArgs[0];
        String[] args = inputArgs.length > 1 ? Arrays.copyOfRange(inputArgs, 1, inputArgs.length - 1) : new String[]{};
        this.windowsChildProcess = WindowsChildProcesses.create();
        if (this.childProcess.hasSystemUser()) {
            this.windowsChildProcess.setUser(new WindowsChildProcessUser(this.childProcess.getSystemUser()));
        }
        this.windowsChildProcess.spawn(executable, args);
        this.getIo().listen();
    }

    @Override
    public void waitForExit() throws Exception {
        this.windowsChildProcess.waitForExit();
        this.io.waitFor();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        this.windowsChildProcess.stop();
    }

    @Override
    public boolean isRunning() {
        return this.windowsChildProcess.hasExited();
    }

    @Override
    public long getId() {
        return this.windowsChildProcess.getId();
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.windowsChildProcess);
    }
}

