/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.terminal.pty;

import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.terminal.io.IIo;
import com.gamedash.daemon.process.childprocess.terminal.io.IOnEventCallback;
import com.gamedash.daemon.process.childprocess.terminal.io.OutputHandler;
import com.gamedash.daemon.process.childprocess.terminal.io.OutputItem;
import com.pty4j.PtyProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Io
extends OutputHandler
implements IIo {
    private static Logger logger = LoggerFactory.getLogger(Io.class);
    private List<IOnEventCallback> onEventCallbacks = new CopyOnWriteArrayList<IOnEventCallback>();
    private boolean isListening = false;
    private boolean hasFinishedReadingStreams = false;

    Io(ChildProcess childProcess) throws IOException {
        super(childProcess);
    }

    @Override
    public void write(String value) throws Exception {
        PrintWriter output = new PrintWriter(this.childProcess.getApi(PtyProcess.class).getOutputStream(), true);
        output.println(value);
    }

    @Override
    public void onOutputEvent(IOnEventCallback callback) {
        this.onEventCallbacks.add(callback);
    }

    private void invokeOnOutputEventCallbacks(OutputItem outputItem) {
        for (IOnEventCallback callback : this.onEventCallbacks) {
            callback.method(outputItem);
        }
    }

    @Override
    public void waitFor() throws Exception {
        while (!this.hasFinishedReadingStreams) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void listen() {
        if (this.isListening) {
            throw new ProcessException("Already listening to io");
        }
        this.isListening = true;
        new Thread(() -> {
            try {
                this.listenToInputStream(this.getInputStream(), false).join();
                this.listenToInputStream(this.getErrorStream(), true).join();
                this.hasFinishedReadingStreams = true;
            }
            catch (Exception e) {
                if (e instanceof IOException && this.childProcess.isTerminating()) {
                    return;
                }
                logger.error(e.getMessage());
            }
        }).start();
    }

    @Override
    public void destroy() throws Exception {
        this.getInputStream().close();
        this.getErrorStream().close();
    }

    private InputStream getInputStream() throws Exception {
        return this.childProcess.getApi(PtyProcess.class).getInputStream();
    }

    private InputStream getErrorStream() throws Exception {
        return this.childProcess.getApi(PtyProcess.class).getErrorStream();
    }

    private Thread listenToInputStream(InputStream inputStream, boolean isErrorStream) {
        Thread thread = new Thread(() -> {
            try {
                String value;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((value = bufferedReader.readLine()) != null) {
                    OutputItem outputItem = new OutputItem(value, isErrorStream);
                    try {
                        this.addOutputItem(outputItem);
                        new Thread(() -> this.invokeOnOutputEventCallbacks(outputItem)).start();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                if (e instanceof IOException && this.childProcess.isTerminating()) {
                    return;
                }
                logger.error(e.getMessage());
            }
        });
        thread.start();
        return thread;
    }
}

