/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.terminal.generic.Generic;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChildProcesses {
    private static List<ChildProcess> processes = new CopyOnWriteArrayList<ChildProcess>();

    public static List<ChildProcess> getAll() {
        return processes;
    }

    public static void stopAll() throws Exception {
        for (ChildProcess childProcess : ChildProcesses.getAll()) {
            if (!childProcess.isRunning() || childProcess.isTerminating()) continue;
            childProcess.stop();
        }
    }

    public static ChildProcess create() throws Exception {
        return ChildProcesses.create(Generic.class);
    }

    public static ChildProcess create(Class terminalClass) throws Exception {
        ChildProcess process = new ChildProcess(terminalClass);
        processes.add(process);
        return process;
    }

    public static ChildProcess get(long pid) throws Exception {
        if (!ChildProcesses.exists(pid)) {
            throw new Exception("Process with pid " + pid + " does not exist");
        }
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != pid) continue;
            return process;
        }
        throw new Exception("Could not get childProcess");
    }

    public static boolean exists(long pid) throws Exception {
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != pid) continue;
            return true;
        }
        return false;
    }
}

