/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.installer;

import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.installer.userInterface.UserInterface;
import com.gamedash.daemon.installer.userInterface.UserInterfaceQuestionsResult;
import java.io.IOException;

public class Installer
extends com.gamedash.daemon.common.installer.Installer {
    public static void install() throws IOException {
        Installer.setState(InstallerStateEnum.inProgress);
        try {
            if (!Config.fileExists("daemon.properties")) {
                Config.createFile("daemon.properties");
            }
            UserInterface ui = new UserInterface();
            UserInterfaceQuestionsResult result = ui.askQuestions();
            Authentication.setToken(result.authenticationToken);
            ApiClientConfig.setDomain(result.apiClientDomain);
            ApiClientConfig.setVersion("1");
            KeyStore.setFile(result.security.keyStoreFile);
            KeyStore.setPassword(result.security.keyStorePassword);
            KeyStore.setIsSelfSigned(result.security.keyStoreIsSelfSigned);
        }
        catch (Exception e) {
            Installer.setState(InstallerStateEnum.notInstalled);
            throw e;
        }
        Installer.setState(InstallerStateEnum.installed);
    }

    public static void uninstall() throws IOException {
        if (Config.fileExists("daemon.properties")) {
            Config.getFile("daemon.properties").delete();
        }
    }
}

