/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.ftp.server.fileSystem;

import com.gamedash.daemon.fileSystem.File;
import com.gamedash.daemon.fileSystem.ftp.server.fileSystem.FtpFile;
import com.gamedash.daemon.fileSystem.ftp.server.user.User;
import java.util.StringTokenizer;
import org.apache.ftpserver.filesystem.nativefs.impl.NameEqualsFileFilter;
import org.apache.ftpserver.filesystem.nativefs.impl.NativeFileSystemView;
import org.apache.ftpserver.ftplet.FtpException;

public class FileSystemView
extends NativeFileSystemView {
    private User user;
    private String currDir;
    private String rootDir;
    private boolean caseInsensitive;

    public FileSystemView(User user, boolean caseInsensitive) throws FtpException {
        super(user, caseInsensitive);
        if (user == null) {
            throw new IllegalArgumentException("User can not be null");
        }
        if (user.getHomeDirectory() == null) {
            throw new IllegalArgumentException("User home directory can not be null");
        }
        this.caseInsensitive = caseInsensitive;
        String rootDir = user.getHomeDirectory();
        rootDir = this.normalizeSeparateChar(rootDir);
        this.rootDir = rootDir = this.appendSlash(rootDir);
        this.user = user;
        this.currDir = "/";
    }

    @Override
    public FtpFile getHomeDirectory() {
        return new FtpFile("/", new File(this.rootDir), this.user);
    }

    @Override
    public FtpFile getWorkingDirectory() {
        FtpFile fileObj = null;
        if (this.currDir.equals("/")) {
            fileObj = new FtpFile("/", new File(this.rootDir), this.user);
        } else {
            File file = new File(this.rootDir, this.currDir.substring(1));
            fileObj = new FtpFile(this.currDir, file, this.user);
        }
        return fileObj;
    }

    @Override
    public FtpFile getFile(String file) {
        String physicalName = this.getPhysicalName(this.rootDir, this.currDir, file, this.caseInsensitive);
        File fileObj = new File(physicalName);
        String userFileName = physicalName.substring(this.rootDir.length() - 1);
        return new FtpFile(userFileName, fileObj, this.user);
    }

    @Override
    public boolean changeWorkingDirectory(String dir) {
        File dirObj = new File((String)(dir = this.getPhysicalName(this.rootDir, this.currDir, (String)dir, this.caseInsensitive)));
        if (!dirObj.isDirectory()) {
            return false;
        }
        if (((String)(dir = ((String)dir).substring(this.rootDir.length() - 1))).charAt(((String)dir).length() - 1) != '/') {
            dir = (String)dir + "/";
        }
        this.currDir = dir;
        return true;
    }

    @Override
    public boolean isRandomAccessible() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    protected String getPhysicalName(String rootDir, String currDir, String fileName, boolean caseInsensitive) {
        Object result;
        String normalizedRootDir = this.normalizeSeparateChar(rootDir);
        normalizedRootDir = this.appendSlash(normalizedRootDir);
        String normalizedFileName = this.normalizeSeparateChar(fileName);
        if (normalizedFileName.charAt(0) != '/') {
            String normalizedCurrDir = this.normalize(currDir, "/");
            result = normalizedRootDir + normalizedCurrDir.substring(1);
        } else {
            result = normalizedRootDir;
        }
        result = this.trimTrailingSlash((String)result);
        StringTokenizer st = new StringTokenizer(normalizedFileName, "/");
        while (st.hasMoreTokens()) {
            java.io.File[] matches;
            String tok = st.nextToken();
            if (tok.equals(".")) continue;
            if (tok.equals("..")) {
                int slashIndex;
                if (!((String)result).startsWith(normalizedRootDir) || (slashIndex = ((String)result).lastIndexOf(47)) == -1) continue;
                result = ((String)result).substring(0, slashIndex);
                continue;
            }
            if (tok.equals("~")) {
                result = this.trimTrailingSlash(normalizedRootDir);
                continue;
            }
            if (caseInsensitive && (matches = new File((String)result).listFiles(new NameEqualsFileFilter(tok, true))) != null && matches.length > 0) {
                tok = matches[0].getName();
            }
            result = (String)result + "/" + tok;
        }
        if (((String)result).length() + 1 == normalizedRootDir.length()) {
            result = (String)result + "/";
        }
        if (!((String)result).startsWith(normalizedRootDir)) {
            result = normalizedRootDir;
        }
        return result;
    }

    private String appendSlash(String path) {
        if (path.charAt(path.length() - 1) != '/') {
            return path + "/";
        }
        return path;
    }

    private String prependSlash(String path) {
        if (path.charAt(0) != '/') {
            return "/" + path;
        }
        return path;
    }

    private String trimTrailingSlash(String path) {
        if (path.charAt(path.length() - 1) == '/') {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String normalizeSeparateChar(String pathName) {
        String normalizedPathName = pathName.replace(File.separatorChar, '/');
        normalizedPathName = normalizedPathName.replace('\\', '/');
        return normalizedPathName;
    }

    private String normalize(String path, String defaultPath) {
        if (path == null || path.trim().length() == 0) {
            path = defaultPath;
        }
        path = this.normalizeSeparateChar(path);
        path = this.prependSlash(this.appendSlash(path));
        return path;
    }
}

