/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem;

import com.gamedash.daemon.enums.fileSystem.FileTypes;
import java.util.Base64;

public class File
extends java.io.File {
    public File(String file) {
        super(file);
    }

    public File(String file, String a) {
        super(file, a);
    }

    public FileTypes getType() {
        return this.isDirectory() ? FileTypes.directory : FileTypes.file;
    }

    public String getExtension() {
        int i = this.getName().lastIndexOf(46);
        if (i >= 0) {
            return this.getName().substring(i + 1);
        }
        return null;
    }

    public File[] listFiles() {
        java.io.File[] nativeFiles = super.listFiles();
        if (nativeFiles == null) {
            return null;
        }
        File[] files = new File[nativeFiles.length];
        for (int i = 0; i < nativeFiles.length; ++i) {
            files[i] = new File(nativeFiles[i].getPath());
        }
        return files;
    }

    public java.io.File toNative() {
        return new java.io.File(this.toPath().toString());
    }

    public static File fromBase64(String path) {
        return new File(new String(Base64.getDecoder().decode(path)));
    }

    public static File fromNative(java.io.File file) {
        return new File(file.toPath().toString());
    }
}

