/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.authentication;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.authentication.AuthenticationTokenValidationResult;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationToken {
    private String token;
    private static List<AuthenticationTokenValidationResult> cachedTokenValidationResults = new ArrayList<AuthenticationTokenValidationResult>();

    public AuthenticationToken(String token) {
        this.token = token;
    }

    public AuthenticationTokenValidationResult validate() throws Exception {
        AuthenticationTokenValidationResult cachedValidationResult = this.getCachedValidationResult();
        if (cachedValidationResult != null) {
            return cachedValidationResult;
        }
        ApiQuery query = ApiClient.createQueryWithoutAuthentication("infrastructure/node/daemon/authentication/token/isvalid");
        query.getParameters().create("token").setValue(this.token);
        boolean isValid = query.get().getJsonObject().get("response").getAsBoolean();
        AuthenticationTokenValidationResult validationResult = new AuthenticationTokenValidationResult(this, isValid);
        cachedTokenValidationResults.add(validationResult);
        return validationResult;
    }

    public String toString() {
        return this.token;
    }

    private AuthenticationTokenValidationResult getCachedValidationResult() {
        for (AuthenticationTokenValidationResult validationResult : cachedTokenValidationResults) {
            if (!validationResult.getToken().toString().equalsIgnoreCase(this.toString())) continue;
            return validationResult;
        }
        return null;
    }
}

