/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import java.io.IOException;
import java.util.UUID;
import spark.Request;
import spark.Response;

public class CreateSession
extends Route<String> {
    public CreateSession(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        int chunkCount = this.getParameters().get("chunkCount").getValue(Integer.class);
        if (destination.exists() && destination.isDirectory()) {
            throw new IOException("Destination path already exists, however it is a directory");
        }
        Session session = Sessions.create(this.getId(), destination, chunkCount);
        if (this.getParameters().exists("chunkSize")) {
            session.setChunkSize(this.getParameters().get("chunkSize").getValue(Long.class));
        }
        return session.getId().toString();
    }

    private UUID getId() throws Exception {
        if (this.getParameters().exists("id")) {
            return UUID.fromString(this.getParameters().get("id").getValue());
        }
        return UUID.randomUUID();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "chunkCount"};
    }
}

