/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlink;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlinks;
import java.io.File;
import java.io.FileInputStream;
import javax.servlet.ServletOutputStream;
import spark.Request;
import spark.Response;

public class Serve
extends Route<Response> {
    private String id = this.getParameters().get("id").getValue();
    private Hotlink hotlink;

    public Serve(Request request, Response response) throws Exception {
        super(request, response);
    }

    @Override
    public Response execute() throws Exception {
        if (!Hotlinks.exists(this.id)) {
            throw new Exception("Hotlink does not exist");
        }
        this.hotlink = Hotlinks.get(this.id);
        File file = this.getFile();
        try (ServletOutputStream outputStream = this.response.raw().getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.transferTo(outputStream);
            outputStream.flush();
        }
        return this.response;
    }

    private File getFile() throws Exception {
        if (this.hotlink.isDirectory()) {
            if (this.request.splat().length < 1) {
                throw new Exception("No path is set");
            }
            String path = this.request.splat()[0];
            return new File(this.hotlink.getFile().getPath() + File.separator + path.replaceAll(".", ""));
        }
        return this.hotlink.getFile();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }
}

