/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents;

import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.ResponseFileTimestamp;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;

public class ResponseFile {
    private String path;
    private Boolean isDirectory;
    private long size;
    private ResponseFileTimestamp timestamp;

    public ResponseFile(File directory, File file) throws Exception {
        BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        this.path = directory.toPath().relativize(file.toPath()).toString();
        this.isDirectory = file.isDirectory();
        if (file.isFile()) {
            this.size = file.length();
            this.timestamp = new ResponseFileTimestamp(attributes.creationTime().toMillis() / 1000L, attributes.lastModifiedTime().toMillis() / 1000L);
        }
    }
}

