/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.JsonTransformer;
import com.gamedash.daemon.api.server.authentication.Authentication;
import com.gamedash.daemon.api.server.parameter.ParameterException;
import com.gamedash.daemon.api.server.route.RouteWrapper;
import com.gamedash.daemon.api.server.route.routes.GetTime;
import com.gamedash.daemon.api.server.route.routes.Ping;
import com.gamedash.daemon.api.server.route.routes.Root;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Append;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Checksum;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Copy;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Delete;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Download;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Exists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.GetSize;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.IsDirectory;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Read;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Serve;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.SetExecutable;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Unzip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.Write;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Move;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.GetContents;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.Walk;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Zip;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.UpdateAll;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.CreateSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.DeleteSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.GetSession;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.SessionExists;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload.WriteChunk;
import com.gamedash.daemon.api.server.route.routes.network.port.Get;
import com.gamedash.daemon.api.server.route.routes.network.port.GetAll;
import com.gamedash.daemon.api.server.route.routes.process.GetChildren;
import com.gamedash.daemon.api.server.route.routes.process.Kill;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Create;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.Stop;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.GetOutput;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.io.SendInput;
import com.gamedash.daemon.api.server.route.routes.relay.host.Broadcast;
import com.gamedash.daemon.api.server.route.routes.system.GetUptime;
import com.gamedash.daemon.api.server.route.routes.system.GetUsage;
import com.gamedash.daemon.api.server.route.routes.system.Shutdown;
import com.gamedash.daemon.api.server.route.routes.system.info.GetInfo;
import com.gamedash.daemon.api.server.route.routes.system.user.AssignPermissions;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;

public class Routes {
    public static void register() {
        ApiServer.getService().get("/", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Root(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/time", (request, response) -> new RouteWrapper(new GetTime(request, response)).execute());
        ApiServer.getService().post("/ping", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Ping(request, response)).execute();
        });
        ApiServer.getService().post("/relay/host/broadcast", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Broadcast(request, response)).execute();
        });
        ApiServer.getService().get("/system/usage", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetUsage(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/system/info", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetInfo(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/system/uptime", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new GetUptime(request, response)).execute();
        });
        ApiServer.getService().post("/system/shutdown", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Shutdown(request, response)).execute();
        });
        ApiServer.getService().post("/process/childprocess", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Create(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/process/childprocess/:id/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.childprocess.Exists(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().delete("/process/childprocess/:id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Stop(request, response)).execute();
        });
        ApiServer.getService().delete("/process/childprocess/:id/kill", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.childprocess.Kill(request, response)).execute();
        });
        ApiServer.getService().get("/process/childprocess/:id/usage", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.childprocess.GetUsage(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().post("/process/childprocess/:id/io/input", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new SendInput(request, response)).execute();
        });
        ApiServer.getService().get("/process/childprocess/:id/io/output", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetOutput(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().delete("/process/:id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Kill(request, response)).execute();
        });
        ApiServer.getService().get("/process/:id/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.process.Exists(request, response)).execute();
        });
        ApiServer.getService().get("/process/:id/children", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetChildren(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/group/zip", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Zip(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/group/copy", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.Copy(request, response)).execute();
        });
        ApiServer.getService().put("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Write(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/isdirectory", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new IsDirectory(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/checksum", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Checksum(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/copy", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Copy(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.Create(request, response)).execute();
        });
        ApiServer.getService().delete("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Delete(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/download", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Download(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Exists(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().post("/filesystem/file/move", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.Move(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Read(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/serve", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Serve(request, response)).execute();
        });
        ApiServer.getService().put("/filesystem/file/setexecutable", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new SetExecutable(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/size", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new GetSize(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/unzip", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Unzip(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Write(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/upload/session", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new CreateSession(request, response)).execute();
        });
        ApiServer.getService().delete("/filesystem/file/upload/session/:session_id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new DeleteSession(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/upload/session/:session_id/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new SessionExists(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().post("/filesystem/file/upload/session/:session_id/chunk/:chunk_id/write", "multipart/form-data", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            request.raw().setAttribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(""));
            Part chunkContentPart = request.raw().getPart("chunkContent");
            if (chunkContentPart == null) {
                throw new ParameterException("No file detected");
            }
            if (chunkContentPart.getSize() == 0L) {
                throw new ParameterException("Uploaded file is empty");
            }
            response.type("application/json");
            return new RouteWrapper(new WriteChunk(request, response, chunkContentPart.getInputStream())).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/filesystem/file/upload/session/:session_id", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetSession(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().put("/filesystem/file/append", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Append(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/directory/copy", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Copy(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/directory", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Create(request, response)).execute();
        });
        ApiServer.getService().delete("/filesystem/file/directory", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.Delete(request, response)).execute();
        });
        ApiServer.getService().post("/filesystem/file/directory/move", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new Move(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/directory/size", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.GetSize(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/directory/contents", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetContents(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/filesystem/file/directory/contents/walk", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Walk(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/network/port/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new GetAll(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().get("/network/port/:number", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.type("application/json");
            return new RouteWrapper(new Get(request, response)).execute();
        }, new JsonTransformer());
        ApiServer.getService().post("/system/user/:name", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.user.Create(request, response)).execute();
        });
        ApiServer.getService().delete("/system/user/:name", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.user.Delete(request, response)).execute();
        });
        ApiServer.getService().get("/system/user/:name/exists", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.system.user.Exists(request, response)).execute();
        });
        ApiServer.getService().put("/system/user/:name/permission/assign", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new AssignPermissions(request, response)).execute();
        });
        ApiServer.getService().put("/filesystem/file/hotlink/update/all", (request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            return new RouteWrapper(new UpdateAll(request, response)).execute();
        });
        ApiServer.getService().get("/filesystem/file/hotlink/:id/serve", (request, response) -> new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.Serve(request, response)).execute());
        ApiServer.getService().get("/filesystem/file/hotlink/:id/serve/*", (request, response) -> new RouteWrapper(new com.gamedash.daemon.api.server.route.routes.fileSystem.file.hotlink.Serve(request, response)).execute());
    }
}

