/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.beust.jcommander.JCommander;
import com.gamedash.daemon.Args;
import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.api.client.ApiClientConfigValidationResult;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.license.LicenseValidation;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.config.Config;
import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlinks;
import com.gamedash.daemon.fileSystem.ftp.server.FtpServer;
import com.gamedash.daemon.infrastructure.node.Nodes;
import com.gamedash.daemon.installer.Installer;
import com.gamedash.daemon.process.childprocess.usage.Usage;
import com.gamedash.daemon.relay.server.RelayServer;
import com.gamedash.daemon.shutdown.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static Args args = new Args();
    private static Logger logger = LoggerFactory.getLogger(Application.class);

    public void run(String[] argv) {
        JCommander.newBuilder().addObject(args).build().parse(argv);
        try {
            ApiClientConfigValidationResult apiClientConfigValidationResult;
            if (Application.args.dev.booleanValue()) {
                DevelopmentMode.setIsEnabled(true);
            }
            Dependencies.install();
            if (Application.args.installOnly.booleanValue() || Installer.getState() == InstallerStateEnum.notInstalled) {
                Installer.install();
                if (Application.args.installOnly.booleanValue()) {
                    System.exit(0);
                }
            }
            if (Application.args.shouldUninstall.booleanValue()) {
                if (Installer.getState() != InstallerStateEnum.installed) {
                    throw new Exception("Daemon is not currently installed");
                }
                Installer.uninstall();
                System.exit(0);
            }
            if (!Config.fileExists("daemon.properties")) {
                throw new ConfigException("daemon.properties does not exist");
            }
            if (Application.args.apiServerPort != null) {
                ApiServer.setPort(Application.args.apiServerPort);
            }
            if (Application.args.apiClientDomain != null) {
                ApiClientConfig.setDomain(Application.args.apiClientDomain);
            }
            if (Application.args.apiClientVersion != null) {
                ApiClientConfig.setVersion(Application.args.apiClientVersion);
            }
            if (!(apiClientConfigValidationResult = ApiClientConfig.validate()).isValid()) {
                throw new Exception(apiClientConfigValidationResult.getMessage() != null ? apiClientConfigValidationResult.getMessage() : "Invalid API client config");
            }
            if (KeyStore.hasFile().booleanValue()) {
                if (!KeyStore.getFile().exists()) {
                    throw new Exception("Keystore file does not exist");
                }
                if (!KeyStore.hasPassword()) {
                    throw new Exception("Keystore password is not set");
                }
                if (KeyStore.isSelfSigned().booleanValue()) {
                    logger.warn("Certificate is self signed");
                }
            }
            if (!LicenseValidation.isValid()) {
                throw new Exception("Invalid license");
            }
            if (!Authentication.isAuthenticated()) {
                throw new Exception("Could not authenticate");
            }
            Shutdown.registerHook();
            this.initProcessUsage();
            this.initApiServer();
            this.initRelayServer();
            this.initFtpServer();
            this.initFileSystemHotlinks();
            Nodes.getSelf().getStatus().update(true);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void shutdown() throws Exception {
        Shutdown.run();
    }

    private void initProcessUsage() {
        new Thread(() -> {
            try {
                if (Usage.isAvailable() && !Usage.isInstalled()) {
                    Usage.install();
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
            }
        }).run();
    }

    private void initApiServer() {
        ApiServer.start();
    }

    private void initRelayServer() throws Exception {
        block3: {
            block2: {
                if (RelayServer.isHost()) break block2;
                if (!Application.args.enableRelay.booleanValue()) break block3;
            }
            logger.info("This daemon is a relay host. Starting relay server...");
            new Thread(() -> {
                try {
                    RelayServer.start();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }).start();
        }
    }

    private void initFtpServer() throws Exception {
        FtpServer ftpServer = FtpServer.getInstance();
        ftpServer.start();
    }

    private void initFileSystemHotlinks() throws Exception {
        Hotlinks.update();
    }
}

