/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.util.ParseUtil;

public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    private static final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private double lastCpuLoad = 0.0;
    private long lastCpuLoadTime = 0L;
    private boolean sunMXBean = false;
    protected int logicalProcessorCount = 0;
    protected int physicalProcessorCount = 0;
    protected int physicalPackageCount = 0;
    private long tickTime;
    private long[] prevTicks;
    private long[] curTicks;
    private long procTickTime;
    private long[][] prevProcTicks;
    private long[][] curProcTicks;
    private String cpuVendor;
    private String cpuName;
    private String processorID;
    private String cpuIdentifier;
    private String cpuStepping;
    private String cpuModel;
    private String cpuFamily;
    private Long cpuVendorFreq;
    private Boolean cpu64;

    public AbstractCentralProcessor() {
        this.initMXBean();
        this.calculateProcessorCounts();
    }

    private void initMXBean() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            this.lastCpuLoad = ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            this.lastCpuLoadTime = System.currentTimeMillis();
            this.sunMXBean = true;
            LOG.debug("Oracle MXBean detected.");
        }
        catch (ClassCastException | ClassNotFoundException e) {
            LOG.debug("Oracle MXBean not detected.");
            LOG.trace("{}", e);
        }
    }

    protected synchronized void initTicks() {
        this.prevProcTicks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        this.curProcTicks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        this.prevTicks = new long[CentralProcessor.TickType.values().length];
        this.curTicks = new long[CentralProcessor.TickType.values().length];
    }

    protected abstract void calculateProcessorCounts();

    @Override
    public String getVendor() {
        if (this.cpuVendor == null) {
            this.setVendor("");
        }
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        if (this.cpuName == null) {
            this.setName("");
        }
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public String getProcessorID() {
        if (this.processorID == null) {
            this.setProcessorID("");
        }
        return this.processorID;
    }

    @Override
    public void setProcessorID(String processorID) {
        this.processorID = processorID;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        if (this.cpuIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getVendor().contentEquals("GenuineIntel")) {
                sb.append(this.isCpu64bit() ? "Intel64" : "x86");
            } else {
                sb.append(this.getVendor());
            }
            sb.append(" Family ").append(this.getFamily());
            sb.append(" Model ").append(this.getModel());
            sb.append(" Stepping ").append(this.getStepping());
            this.setIdentifier(sb.toString());
        }
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        if (this.cpu64 == null) {
            this.setCpu64(false);
        }
        return this.cpu64;
    }

    @Override
    public void setCpu64(boolean value) {
        this.cpu64 = value;
    }

    @Override
    public String getStepping() {
        if (this.cpuStepping == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setStepping(this.parseIdentifier("Stepping"));
        }
        return this.cpuStepping;
    }

    @Override
    public void setStepping(String stepping) {
        this.cpuStepping = stepping;
    }

    @Override
    public String getModel() {
        if (this.cpuModel == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setModel(this.parseIdentifier("Model"));
        }
        return this.cpuModel;
    }

    @Override
    public void setModel(String model) {
        this.cpuModel = model;
    }

    @Override
    public String getFamily() {
        if (this.cpuFamily == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setFamily(this.parseIdentifier("Family"));
        }
        return this.cpuFamily;
    }

    @Override
    public void setFamily(String family) {
        this.cpuFamily = family;
    }

    private String parseIdentifier(String id) {
        String[] idSplit = ParseUtil.whitespaces.split(this.getIdentifier());
        boolean found = false;
        for (String s2 : idSplit) {
            if (found) {
                return s2;
            }
            found = s2.equals(id);
        }
        return "";
    }

    @Override
    public synchronized double getSystemCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)this.tickTime);
        if (now - this.tickTime > 950L) {
            this.updateSystemTicks();
        }
        long total = 0L;
        for (int i = 0; i < this.curTicks.length; ++i) {
            total += this.curTicks[i] - this.prevTicks[i];
        }
        long idle = this.curTicks[CentralProcessor.TickType.IDLE.getIndex()] + this.curTicks[CentralProcessor.TickType.IOWAIT.getIndex()] - this.prevTicks[CentralProcessor.TickType.IDLE.getIndex()] - this.prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    protected void updateSystemTicks() {
        long[] ticks;
        LOG.trace("Updating System Ticks");
        for (long tick : ticks = this.getSystemCpuLoadTicks()) {
            if (tick == 0L) continue;
            this.tickTime = System.currentTimeMillis();
            System.arraycopy(this.curTicks, 0, this.prevTicks, 0, this.curTicks.length);
            System.arraycopy(ticks, 0, this.curTicks, 0, ticks.length);
            return;
        }
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.sunMXBean) {
            long now = System.currentTimeMillis();
            if (now - this.lastCpuLoadTime < 200L) {
                return this.lastCpuLoad;
            }
            this.lastCpuLoad = ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            this.lastCpuLoadTime = now;
            return this.lastCpuLoad;
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return this.getSystemLoadAverage(1)[0];
    }

    @Override
    public double[] getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)this.procTickTime);
        if (now - this.procTickTime > 950L) {
            this.updateProcessorTicks();
        }
        double[] load = new double[this.logicalProcessorCount];
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long total = 0L;
            for (int i = 0; i < this.curProcTicks[cpu].length; ++i) {
                total += this.curProcTicks[cpu][i] - this.prevProcTicks[cpu][i];
            }
            long idle = this.curProcTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()] + this.curProcTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()] - this.prevProcTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()] - this.prevProcTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()];
            LOG.trace("CPU: {}  Total ticks: {}  Idle ticks: {}", cpu, total, idle);
            load[cpu] = total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
        }
        return load;
    }

    protected void updateProcessorTicks() {
        long[][] ticks;
        LOG.trace("Updating Processor Ticks");
        long[][] lArray = ticks = this.getProcessorCpuLoadTicks();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] tick;
            for (long element : tick = lArray[i]) {
                int cpu;
                if (element == 0L) continue;
                this.procTickTime = System.currentTimeMillis();
                for (cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                    System.arraycopy(this.curProcTicks[cpu], 0, this.prevProcTicks[cpu], 0, this.curProcTicks[cpu].length);
                }
                for (cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                    System.arraycopy(ticks[cpu], 0, this.curProcTicks[cpu], 0, ticks[cpu].length);
                }
                return;
            }
        }
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    @Override
    public int getPhysicalPackageCount() {
        return this.physicalPackageCount;
    }

    public String toString() {
        return this.getName();
    }

    protected String createProcessorID(String stepping, String model, String family, String[] flags) {
        long processorIdBytes = 0L;
        long steppingL = ParseUtil.parseLongOrDefault(stepping, 0L);
        long modelL = ParseUtil.parseLongOrDefault(model, 0L);
        long familyL = ParseUtil.parseLongOrDefault(family, 0L);
        processorIdBytes |= steppingL & 0xFL;
        processorIdBytes |= (modelL & 0xFL) << 4;
        processorIdBytes |= (modelL & 0xF0L) << 16;
        processorIdBytes |= (familyL & 0xFL) << 8;
        processorIdBytes |= (familyL & 0xF0L) << 20;
        String[] stringArray = flags;
        int n = stringArray.length;
        block64: for (int i = 0; i < n; ++i) {
            String flag;
            switch (flag = stringArray[i]) {
                case "fpu": {
                    processorIdBytes |= 0x100000000L;
                    continue block64;
                }
                case "vme": {
                    processorIdBytes |= 0x200000000L;
                    continue block64;
                }
                case "de": {
                    processorIdBytes |= 0x400000000L;
                    continue block64;
                }
                case "pse": {
                    processorIdBytes |= 0x800000000L;
                    continue block64;
                }
                case "tsc": {
                    processorIdBytes |= 0x1000000000L;
                    continue block64;
                }
                case "msr": {
                    processorIdBytes |= 0x2000000000L;
                    continue block64;
                }
                case "pae": {
                    processorIdBytes |= 0x4000000000L;
                    continue block64;
                }
                case "mce": {
                    processorIdBytes |= 0x8000000000L;
                    continue block64;
                }
                case "cx8": {
                    processorIdBytes |= 0x10000000000L;
                    continue block64;
                }
                case "apic": {
                    processorIdBytes |= 0x20000000000L;
                    continue block64;
                }
                case "sep": {
                    processorIdBytes |= 0x80000000000L;
                    continue block64;
                }
                case "mtrr": {
                    processorIdBytes |= 0x100000000000L;
                    continue block64;
                }
                case "pge": {
                    processorIdBytes |= 0x200000000000L;
                    continue block64;
                }
                case "mca": {
                    processorIdBytes |= 0x400000000000L;
                    continue block64;
                }
                case "cmov": {
                    processorIdBytes |= 0x800000000000L;
                    continue block64;
                }
                case "pat": {
                    processorIdBytes |= 0x1000000000000L;
                    continue block64;
                }
                case "pse-36": {
                    processorIdBytes |= 0x2000000000000L;
                    continue block64;
                }
                case "psn": {
                    processorIdBytes |= 0x4000000000000L;
                    continue block64;
                }
                case "clfsh": {
                    processorIdBytes |= 0x8000000000000L;
                    continue block64;
                }
                case "ds": {
                    processorIdBytes |= 0x20000000000000L;
                    continue block64;
                }
                case "acpi": {
                    processorIdBytes |= 0x40000000000000L;
                    continue block64;
                }
                case "mmx": {
                    processorIdBytes |= 0x80000000000000L;
                    continue block64;
                }
                case "fxsr": {
                    processorIdBytes |= 0x100000000000000L;
                    continue block64;
                }
                case "sse": {
                    processorIdBytes |= 0x200000000000000L;
                    continue block64;
                }
                case "sse2": {
                    processorIdBytes |= 0x400000000000000L;
                    continue block64;
                }
                case "ss": {
                    processorIdBytes |= 0x800000000000000L;
                    continue block64;
                }
                case "htt": {
                    processorIdBytes |= 0x1000000000000000L;
                    continue block64;
                }
                case "tm": {
                    processorIdBytes |= 0x2000000000000000L;
                    continue block64;
                }
                case "ia64": {
                    processorIdBytes |= 0x4000000000000000L;
                    continue block64;
                }
                case "pbe": {
                    processorIdBytes |= Long.MIN_VALUE;
                    continue block64;
                }
            }
        }
        return String.format("%016X", processorIdBytes);
    }
}

