/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.childProcess;

import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.childProcess.IOnExitCallback;
import com.gamedash.daemon.windows.childProcess.IOnOutputCallback;
import com.gamedash.daemon.windows.childProcess.OutputItem;
import com.gamedash.daemon.windows.childProcess.User;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChildProcess {
    private int id;
    private User user;
    private List<IOnOutputCallback> onOutputCallbacks = new ArrayList<IOnOutputCallback>();
    private List<IOnExitCallback> onExitCallbacks = new ArrayList<IOnExitCallback>();
    private int currentOutputPointer = 0;
    private File workingDirectory = FileSystemHelpers.getOwnDirectory(ChildProcess.class);
    private Thread outputListenerThread;

    public int getId() {
        return this.id;
    }

    public void spawn(String executable, String[] args) throws WindowsChildProcessException {
        int id;
        if (this.hasUser()) {
            User user = this.getUser();
            id = WindowsBridge.getInstance().spawnChildProcessAsUser(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath(), user.getSystemUser().getName(), user.getPassword());
        } else {
            id = WindowsBridge.getInstance().spawnChildProcess(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath());
        }
        if (id == -1) {
            throw new WindowsChildProcessException("Could not spawn process");
        }
        this.id = id;
        this.outputListenerThread = new Thread(this::listenForOutput);
        this.outputListenerThread.start();
        new Thread(this::listenForExit).start();
    }

    public void stop() {
        WindowsBridge.getInstance().stopChildProcess(this.getId());
    }

    public void kill() {
        WindowsBridge.getInstance().killChildProcess(this.getId());
    }

    public void waitForExit() {
        WindowsBridge.getInstance().waitForChildProcessExit(this.getId());
        this.waitForOutput();
    }

    public void onOutput(IOnOutputCallback callback) {
        this.onOutputCallbacks.add(callback);
    }

    public void onExit(IOnExitCallback callback) {
        this.onExitCallbacks.add(callback);
    }

    public User getUser() {
        return this.user;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    private void listenForExit() {
        this.waitForExit();
        this.onExitCallbacks.forEach(IOnExitCallback::method);
        if (this.outputListenerThread != null && this.outputListenerThread.isAlive()) {
            this.outputListenerThread.interrupt();
        }
    }

    private void listenForOutput() {
        try {
            while (true) {
                List<String> serializedOutputItems;
                if (this.currentOutputPointer != (serializedOutputItems = Arrays.asList(WindowsBridge.getInstance().getChildProcessOutput(this.getId()).split(","))).size() - 1) {
                    int outputCount = this.getProcessOutputCount() - 1;
                    List<String> newSerializedOutputItems = serializedOutputItems.subList(this.currentOutputPointer, outputCount);
                    newSerializedOutputItems.forEach(item -> {
                        OutputItem outputItem = new OutputItem((String)item, false);
                        this.onOutputCallbacks.forEach(callback -> callback.method(outputItem));
                    });
                    this.currentOutputPointer = outputCount;
                }
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void waitForOutput() {
        try {
            while (!WindowsBridge.getInstance().childProcessHasExited(this.getId()) || this.getProcessOutputCount() - 1 != this.currentOutputPointer) {
                Thread.sleep(200L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getProcessOutputCount() {
        return WindowsBridge.getInstance().getChildProcessOutputCount(this.getId());
    }
}

