/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.user;

import com.gamedash.daemon.system.user.ISystemUser;
import com.gamedash.daemon.system.user.linux.LinuxSystemUser;
import com.gamedash.daemon.system.user.windows.WindowsSystemUser;
import java.io.File;
import org.apache.commons.lang3.SystemUtils;

public class SystemUser {
    private String name;
    private ISystemUser instance;

    public SystemUser(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPassword(String password) throws Exception {
        this.getInstance().setPassword(password);
    }

    public void assignPermissions(File directory) throws Exception {
        this.getInstance().assignPermissions(directory);
    }

    public void setHomeDirectory(File directory) throws Exception {
        this.getInstance().setHomeDirectory(directory);
    }

    public void delete() throws Exception {
        this.getInstance().delete();
    }

    private ISystemUser getInstance() throws Exception {
        if (this.instance == null) {
            this.instance = SystemUser.getSystemUserClass().getConstructor(String.class).newInstance(this.getName());
        }
        return this.instance;
    }

    public static Class<? extends ISystemUser> getSystemUserClass() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return WindowsSystemUser.class;
        }
        return LinuxSystemUser.class;
    }
}

