/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.listener.removeChannels;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.listener.DataListener;
import com.gamedash.daemon.relay.server.channel.Channel;
import com.gamedash.daemon.relay.server.channel.Channels;
import com.gamedash.daemon.relay.server.client.Client;
import com.gamedash.daemon.relay.server.client.Clients;
import com.gamedash.daemon.relay.server.listener.IListener;
import com.gamedash.daemon.relay.server.listener.removeChannels.Input;
import com.gamedash.daemon.relay.server.objects.response.Error;

public class RemoveChannels
implements IListener {
    public static void listen(SocketIOServer server) {
        server.addEventListener("removeChannel", Input.class, new DataListener<Input>(){

            @Override
            public void onData(SocketIOClient socketIoClient, Input input, AckRequest ackRequest) {
                Client client = Clients.get(socketIoClient.getSessionId());
                input.getChannels().forEach(channelName -> {
                    if (!Channels.exists(channelName)) {
                        ackRequest.sendAckData(new Error("Currently not subscribed to channel " + channelName));
                        return;
                    }
                    Channel channel = Channels.get(channelName);
                    client.getChannels().remove(channel);
                });
            }
        });
    }
}

