/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.listener.addChannels;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.listener.DataListener;
import com.gamedash.daemon.relay.server.channel.Channel;
import com.gamedash.daemon.relay.server.channel.Channels;
import com.gamedash.daemon.relay.server.client.Client;
import com.gamedash.daemon.relay.server.client.Clients;
import com.gamedash.daemon.relay.server.listener.IListener;
import com.gamedash.daemon.relay.server.listener.addChannels.Input;
import com.gamedash.daemon.relay.server.objects.response.Error;

public class AddChannels
implements IListener {
    public static void listen(SocketIOServer server) {
        server.addEventListener("addChannel", Input.class, new DataListener<Input>(){

            @Override
            public void onData(SocketIOClient socketIoClient, Input input, AckRequest ackRequest) {
                input.getChannels().forEach(channelName -> {
                    Channel channel = Channels.get(channelName);
                    Client client = Clients.get(socketIoClient.getSessionId());
                    if (channel.getClients().has(client)) {
                        ackRequest.sendAckData(new Error("Already subscribed to channel " + channelName));
                        return;
                    }
                    channel.getClients().add(client);
                });
            }
        });
    }
}

