/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.channel;

import com.gamedash.daemon.relay.ChannelException;
import com.gamedash.daemon.relay.server.channel.Channel;
import com.gamedash.daemon.relay.server.client.Client;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Clients {
    private Channel channel;
    private List<Client> clients = new CopyOnWriteArrayList<Client>();

    public Clients(Channel channel) {
        this.channel = channel;
    }

    public List<Client> getAll() {
        return this.clients;
    }

    public void add(Client client) {
        this.getAll().add(client);
    }

    public void remove(Client client) {
        if (!this.has(client)) {
            throw new ChannelException("Client does not exist");
        }
        for (Client _client : this.getAll()) {
            if (!_client.getId().equals(client.getId())) continue;
            this.getAll().remove(_client);
        }
        if (this.getAll().size() < 1) {
            this.channel.delete();
        }
    }

    public boolean has(Client client) {
        for (Client _client : this.getAll()) {
            if (!_client.getId().equals(client.getId())) continue;
            return true;
        }
        return false;
    }
}

