/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.channel;

import com.gamedash.daemon.relay.Message;
import com.gamedash.daemon.relay.server.channel.Channels;
import com.gamedash.daemon.relay.server.channel.Clients;
import com.gamedash.daemon.relay.server.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static Logger logger = LoggerFactory.getLogger(Channel.class);
    private String name;
    private Clients clients = new Clients(this);

    public Channel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Clients getClients() {
        return this.clients;
    }

    public boolean compareName(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    public void delete() {
        Channels.getAll().remove(this);
    }

    public void broadcast(Message message) {
        logger.debug("Broadcasting message \"" + message.getMessage() + "\" with type " + message.getType() + " to channel " + this.getName());
        message.setChannel(this.getName());
        for (Client client : this.getClients().getAll()) {
            client.sendMessage(message);
        }
    }
}

