/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.config.Config;
import com.gamedash.daemon.infrastructure.node.Nodes;
import com.gamedash.daemon.relay.host.Hosts;
import com.gamedash.daemon.relay.server.client.Client;
import com.gamedash.daemon.relay.server.client.Clients;
import com.gamedash.daemon.relay.server.listener.addChannels.AddChannels;
import com.gamedash.daemon.relay.server.listener.channelExists.ChannelExists;
import com.gamedash.daemon.relay.server.listener.getChannels.GetChannels;
import com.gamedash.daemon.relay.server.listener.removeChannels.RemoveChannels;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayServer {
    private static Logger logger = LoggerFactory.getLogger(RelayServer.class);
    private static SocketIOServer server;

    public static void start() throws Exception {
        int port = RelayServer.getPort();
        logger.info("Starting relay server on port " + port, (Object)"relay");
        Configuration configuration = new Configuration();
        configuration.setHostname("0.0.0.0");
        configuration.setPort(port);
        if (KeyStore.hasFile().booleanValue() && KeyStore.getFile().exists() && KeyStore.hasPassword()) {
            configuration.setKeyStore(new FileInputStream(KeyStore.getFile()));
            configuration.setKeyStorePassword(KeyStore.getPassword());
        }
        SocketConfig socketConfiguration = configuration.getSocketConfig();
        socketConfiguration.setReuseAddress(true);
        server = new SocketIOServer(configuration);
        server.addConnectListener(new ConnectListener(){

            @Override
            public void onConnect(SocketIOClient socketIoClient) {
                try {
                    if (!Clients.exists(socketIoClient.getSessionId())) {
                        Clients.create(socketIoClient);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.addDisconnectListener(new DisconnectListener(){

            @Override
            public void onDisconnect(SocketIOClient socketIoClient) {
                if (Clients.exists(socketIoClient.getSessionId())) {
                    Client client = Clients.get(socketIoClient.getSessionId());
                    client.delete();
                }
            }
        });
        AddChannels.listen(server);
        RemoveChannels.listen(server);
        GetChannels.listen(server);
        ChannelExists.listen(server);
        server.start();
    }

    public static void stop() throws Exception {
        if (!RelayServer.hasStarted()) {
            throw new Exception("Server is currently not running");
        }
        logger.info("Stopping relay server");
        Clients.getAll().forEach(client -> client.delete());
        server.stop();
    }

    public static boolean hasStarted() {
        return server != null;
    }

    public static boolean isHost() throws Exception {
        return Hosts.hasCurrent() && Hosts.getCurrent().getId().equalsIgnoreCase(Nodes.getSelf().getId());
    }

    public static int getPort() throws IOException, ConfigException {
        if (Config.fileExists("daemon.properties")) {
            return 2148;
        }
        return Config.getFile("daemon.properties").getValue("relay.server.port", Integer.class);
    }
}

