/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.type;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.IProcessCpuLimiter;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.Processes;
import java.util.ArrayList;
import java.util.List;

public class CpuLimiter
implements IProcessCpuLimiter {
    private static final int tickTime = 1000;
    private IProcess process;
    private int percentage = 100;
    private boolean isRunning = false;
    private boolean processIsRunning = false;
    private List<IProcess> processes = new ArrayList<IProcess>();
    private Thread tickThread;
    private Thread updateProcessesThread;

    public CpuLimiter(IProcess process) {
        this.process = process;
    }

    @Override
    public void limit(int percentage) throws Exception {
        if (this.isRunning()) {
            throw new ProcessException("CPU limiter is already running");
        }
        this.setPercentage(percentage);
        this.updateProcesses();
        this.tickThread = new Thread(() -> {
            try {
                this.tick();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.tickThread.start();
        this.updateProcessesThread = new Thread(() -> {
            try {
                while (true) {
                    this.updateProcesses();
                    Thread.sleep(10000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        });
        this.updateProcessesThread.start();
    }

    @Override
    public void stop() throws Exception {
        if (!this.isRunning()) {
            throw new ProcessException("CPU limiter is not running");
        }
        this.setIsRunning(false);
        if (this.tickThread != null) {
            this.tickThread.interrupt();
        }
        if (this.updateProcessesThread != null) {
            this.updateProcessesThread.interrupt();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public int getPercentage() {
        return this.percentage;
    }

    @Override
    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    private boolean processIsRunning() {
        return this.processIsRunning;
    }

    private void setProcessIsRunning(boolean isRunning) {
        this.processIsRunning = isRunning;
    }

    private List<IProcess> getProcesses() {
        return this.processes;
    }

    private void setProcesses(List<IProcess> processes) {
        this.processes = processes;
    }

    private void updateProcesses() throws Exception {
        ArrayList<IProcess> processes = new ArrayList<IProcess>();
        processes.add(this.process);
        processes.addAll(this.process.getChildren());
        this.setProcesses(processes);
    }

    private int calculateRunningTime() {
        float percentile = (float)this.getPercentage() / 100.0f;
        return (int)(1000.0f * percentile);
    }

    private int calculateIdleTime() {
        return 1000 - this.calculateRunningTime();
    }

    private void tick() throws Exception {
        boolean processIsRunning = this.processIsRunning();
        this.setProcessIsRunning(!processIsRunning);
        for (IProcess process : this.getProcesses()) {
            process.kill(processIsRunning ? "SIGSTOP" : "SIGCONT");
        }
        int timeout = processIsRunning ? this.calculateIdleTime() : this.calculateRunningTime();
        Thread.sleep(timeout);
        if (Processes.exists(this.process.getId())) {
            this.tick();
        }
    }
}

