/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.terminal.generic;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.terminal.ITerminal;
import com.gamedash.daemon.process.childprocess.terminal.generic.Io;
import com.gamedash.daemon.process.childprocess.terminal.io.IIo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Generic
implements ITerminal {
    private IIo io;
    private ChildProcess childProcess;
    private Process api;
    private long id;

    public Generic(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        if (this.childProcess.hasWorkingDirectory().booleanValue()) {
            processBuilder.directory(this.childProcess.getWorkingDirectory());
        }
        for (Map.Entry<String, String> entry : this.childProcess.getEnvironmentVariables().entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            processBuilder.environment().put(name, value);
        }
        this.api = processBuilder.start();
        this.getIo().listen();
        this.id = this.api.pid();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        this.api.destroy();
        if (this.api.isAlive()) {
            this.api.destroyForcibly();
        }
    }

    @Override
    public void waitFor() throws Exception {
        this.api.waitFor();
        this.getIo().waitFor();
    }

    @Override
    public boolean isRunning() {
        if (this.api == null) {
            return false;
        }
        return this.api.isAlive();
    }

    @Override
    public long getId() {
        return this.id;
    }

    private List<ProcessHandle> getChildProcesses() {
        ArrayList<ProcessHandle> processes = new ArrayList<ProcessHandle>();
        this.api.toHandle().descendants().forEach(processes::add);
        return processes;
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }
}

