/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess;

import com.gamedash.daemon.common.listener.Listeners;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childprocess.ChildProcesses;
import com.gamedash.daemon.process.childprocess.CpuLimiter;
import com.gamedash.daemon.process.childprocess.crash.CrashManager;
import com.gamedash.daemon.process.childprocess.reference.References;
import com.gamedash.daemon.process.childprocess.terminal.IOnExit;
import com.gamedash.daemon.process.childprocess.terminal.Terminal;
import com.gamedash.daemon.process.childprocess.terminal.io.IIo;
import com.gamedash.daemon.process.childprocess.usage.Usage;
import com.gamedash.daemon.shutdown.Shutdown;
import com.gamedash.daemon.utilities.Os;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcess {
    private static Logger logger = LoggerFactory.getLogger(ChildProcess.class);
    private Terminal terminal;
    private References references;
    private CrashManager crashManager;
    private Usage usage;
    private Listeners listeners = new Listeners();
    private File workingDirectory;
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private IProcess process;
    private CpuLimiter cpuLimiter;
    private boolean useShell = true;
    private boolean isTerminating = false;
    private boolean shouldReportCrashes = false;

    public ChildProcess(Class terminalClass) throws Exception {
        this.terminal = new Terminal(this, terminalClass);
        this.references = new References(this);
        this.crashManager = new CrashManager(this);
        this.usage = new Usage(this);
        this.cpuLimiter = new CpuLimiter(this);
    }

    public void spawn(String executable, String[] args) throws Exception {
        logger.debug("Spawning childProcess");
        ArrayList<Object> spawnArgs = new ArrayList<Object>();
        if (Os.isWindows()) {
            spawnArgs.add("cmd.exe");
            spawnArgs.add("/d");
            spawnArgs.add("/s");
            spawnArgs.add("/c");
            spawnArgs.add(executable);
            for (String arg : args) {
                spawnArgs.add(arg);
            }
        } else if (Os.isUnix()) {
            if (this.isUsingShell()) {
                spawnArgs.add("/bin/sh");
                spawnArgs.add("-c");
                spawnArgs.add(executable + " " + String.join((CharSequence)" ", args));
            } else {
                spawnArgs.add(executable);
                for (String arg : args) {
                    spawnArgs.add(arg);
                }
            }
        }
        try {
            this.getTerminal().getInstance().spawn(spawnArgs.toArray(new String[0]));
            this.onExit(() -> {
                if (this.getReferences().has()) {
                    this.getReferences().removeAllLocal();
                }
                if (this.shouldReportCrashes() && !this.isTerminating() && !Shutdown.isShuttingDown()) {
                    new Thread(() -> {
                        try {
                            this.crashManager.report();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }).start();
                }
                this.delete();
            });
        }
        catch (Exception exception) {
            this.getReferences().removeAllLocal();
            throw exception;
        }
        this.listenForExit();
    }

    public void stop() throws Exception {
        if (this.isTerminating()) {
            throw new ProcessException("Process is already not running any more");
        }
        if (!this.isRunning()) {
            throw new ProcessException("Process is already not running any more");
        }
        this.setIsTerminating(true);
        try {
            for (IProcess process : this.getChildren()) {
                try {
                    if (!Processes.exists(process.getId())) continue;
                    process.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.getTerminal().getInstance().stop();
        }
        catch (Exception exception) {
            this.setIsTerminating(false);
            throw exception;
        }
    }

    public void kill() throws Exception {
        this.stop();
    }

    public boolean isUsingShell() {
        return this.useShell;
    }

    public void setUseShell(boolean useShell) {
        this.useShell = useShell;
    }

    public IProcess getProcess() throws Exception {
        if (this.process == null) {
            this.process = Processes.get(this.getId());
        }
        return this.process;
    }

    public List<IProcess> getChildren() throws Exception {
        return this.getProcess().getChildren();
    }

    public CpuLimiter getCpuLimiter() {
        return this.cpuLimiter;
    }

    public boolean exists() throws Exception {
        return ChildProcesses.exists(this.getId());
    }

    public void delete() throws Exception {
        if (!this.exists()) {
            throw new ProcessException("Process does not exist");
        }
        if (this.isRunning()) {
            throw new ProcessException("This childProcess is still running");
        }
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != this.getId()) continue;
            ChildProcesses.getAll().remove(process);
        }
    }

    public void onExit(IOnExit callback) throws Exception {
        this.listeners.get("onExit").addCallback(() -> {
            try {
                callback.method();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
    }

    public void waitFor() throws Exception {
        this.getTerminal().getInstance().waitFor();
    }

    public boolean isRunning() throws Exception {
        return this.getTerminal().getInstance().isRunning();
    }

    public long getId() throws Exception {
        return this.getTerminal().getInstance().getId();
    }

    public IIo getIo() throws Exception {
        return this.getTerminal().getInstance().getIo();
    }

    public Usage getUsage() {
        return this.usage;
    }

    public <T> T getApi(Class<T> type) throws Exception {
        return this.getTerminal().getInstance().getApi(type);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public References getReferences() {
        return this.references;
    }

    private void listenForExit() {
        new Thread(() -> {
            try {
                while (true) {
                    if (!this.isRunning()) {
                        this.listeners.get("onExit").invoke();
                        break;
                    }
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    public boolean isTerminating() {
        return this.isTerminating;
    }

    private void setIsTerminating(boolean isTerminating) {
        this.isTerminating = isTerminating;
    }

    public boolean shouldReportCrashes() {
        return this.shouldReportCrashes;
    }

    public void setShouldReportCrashes(boolean shouldReportCrashes) {
        this.shouldReportCrashes = shouldReportCrashes;
    }

    public File getWorkingDirectory() throws Exception {
        if (!this.hasWorkingDirectory().booleanValue()) {
            throw new Exception("No working directory is set");
        }
        return this.workingDirectory;
    }

    public Boolean hasWorkingDirectory() {
        return this.workingDirectory != null;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void addEnvironmentVariable(String name, String value) {
        this.environmentVariables.put(name, value);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }
}

