/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.type.LinuxProcess;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class Processes {
    public static List<IProcess> getAll() throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            ArrayList<IProcess> processes = new ArrayList<IProcess>();
            File[] files = new File("/proc").listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || !StringUtils.isNumeric(file.getName())) continue;
                    processes.add(Processes.get(Integer.parseInt(file.getName())));
                }
            }
            return processes;
        }
        return new ArrayList<IProcess>();
    }

    public static IProcess get(long id) throws Exception {
        if (!Processes.exists(id)) {
            throw new ProcessNotFoundException(id);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return new LinuxProcess(id);
        }
        throw new Exception("Platform not supported");
    }

    public static boolean exists(long id) {
        if (SystemUtils.IS_OS_LINUX) {
            return new File("/proc/" + id).exists();
        }
        return false;
    }
}

