/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.ftp.server.command;

import com.gamedash.daemon.fileSystem.ftp.server.user.User;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedDataTransferFtpReply;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(org.apache.ftpserver.command.impl.STOR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        block28: {
            User user = (User)context.getUserManager().getUserByName(session.getUser().getName());
            try {
                DataConnection dataConnection;
                InetAddress address;
                long skipLen = session.getFileOffset();
                String fileName = request.getArgument();
                if (fileName == null) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 501, "STOR", null, null));
                    return;
                }
                ServerDataConnectionFactory connFactory = session.getDataConnection();
                if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                    session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                    return;
                }
                FtpFile file = null;
                try {
                    file = session.getFileSystemView().getFile(fileName);
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", ex);
                }
                if (file == null) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 550, "STOR.invalid", fileName, file));
                    return;
                }
                fileName = file.getAbsolutePath();
                if (!file.isWritable()) {
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 550, "STOR.permission", fileName, file));
                    return;
                }
                session.write(LocalizedFtpReply.translate(session, request, context, 150, "STOR", fileName)).awaitUninterruptibly(10000L);
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception getting the input data stream", e);
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 425, "STOR", fileName, file));
                    session.resetState();
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                boolean failure = false;
                OutputStream outStream = null;
                long transSz = 0L;
                try {
                    outStream = file.createOutputStream(skipLen);
                    transSz = dataConnection.transferFromClient(session.getFtpletSession(), outStream);
                    if (outStream != null) {
                        outStream.close();
                    }
                    this.LOG.info("File uploaded {}", (Object)fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                    ftpStat.setUpload(session, file, transSz);
                }
                catch (SocketException ex) {
                    this.LOG.debug("Socket exception during data transfer", ex);
                    failure = true;
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 426, "STOR", fileName, file));
                }
                catch (IOException ex) {
                    this.LOG.debug("IOException during data transfer", ex);
                    failure = true;
                    session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 551, "STOR", fileName, file));
                }
                finally {
                    IoUtils.close(outStream);
                }
                if (failure) break block28;
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 226, "STOR", fileName, file, transSz));
                try {
                    if (user.hasSystemUser()) {
                        user.getSystemUser().assignPermissions(new File(user.getHomeDirectory()));
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            finally {
                session.resetState();
                session.getDataConnection().closeDataConnection();
            }
        }
    }
}

