/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.ftp.server;

import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.config.Config;
import com.gamedash.daemon.fileSystem.ftp.server.FtpServerFactory;
import com.gamedash.daemon.fileSystem.ftp.server.fileSystem.FileSystemFactory;
import com.gamedash.daemon.fileSystem.ftp.server.user.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfigurationFactory;

public class FtpServer {
    private UserManager userManager = new UserManager();
    private static FtpServer instance;
    private org.apache.ftpserver.FtpServer ftpServer;
    private int port = 21;
    private int tlsPort = 990;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Can not set port when the server is running");
        }
        this.port = port;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public void setTlsPort(int port) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Can not set port when the server is running");
        }
        this.tlsPort = port;
    }

    public boolean isRunning() {
        return this.ftpServer != null && !this.ftpServer.isStopped();
    }

    public void start() throws Exception {
        if (this.isRunning()) {
            throw new Exception("Server is already running");
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        if (!KeyStore.hasFile().booleanValue() || Config.fileExists("ftp.server.requireTls") && !Config.getFile("daemon.properties").getValue("ftp.server.requireTls", Boolean.class).booleanValue()) {
            ListenerFactory factory = new ListenerFactory();
            factory.setPort(this.getPort());
            serverFactory.addListener("default", factory.createListener());
        }
        if (KeyStore.hasFile().booleanValue()) {
            ListenerFactory tlsFactory = new ListenerFactory();
            tlsFactory.setPort(this.getTlsPort());
            SslConfigurationFactory ssl = new SslConfigurationFactory();
            ssl.setKeystoreFile(KeyStore.getFile());
            ssl.setKeystorePassword(KeyStore.getPassword());
            tlsFactory.setSslConfiguration(ssl.createSslConfiguration());
            tlsFactory.setImplicitSsl(true);
            serverFactory.addListener("tls", tlsFactory.createListener());
        }
        serverFactory.setUserManager(FtpServer.getInstance().getUserManager());
        FileSystemFactory fileSystemFactory = new FileSystemFactory();
        fileSystemFactory.setCreateHome(false);
        serverFactory.setFileSystem(fileSystemFactory);
        org.apache.ftpserver.FtpServer ftpServer = serverFactory.createServer();
        ftpServer.start();
        this.ftpServer = ftpServer;
    }

    public void stop() {
        this.ftpServer.stop();
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public static FtpServer getInstance() {
        if (instance == null) {
            instance = new FtpServer();
        }
        return instance;
    }
}

