/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.authentication;

import com.gamedash.daemon.common.authentication.AuthenticationException;
import com.gamedash.daemon.common.authentication.AuthenticationToken;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import java.io.IOException;

public class Authentication {
    public static boolean isAuthenticated() throws Exception {
        return Authentication.hasToken() && Authentication.getToken().validate().isValid();
    }

    public static AuthenticationToken getToken() throws Exception {
        if (!Authentication.hasToken()) {
            throw new AuthenticationException("No token is set");
        }
        return new AuthenticationToken(Config.getFile("daemon.properties").getValue("authentication.token"));
    }

    public static boolean hasToken() throws IOException, ConfigException {
        return Config.getFile("daemon.properties").valueExists("authentication.token");
    }

    public static void setToken(AuthenticationToken token) throws IOException, ConfigException {
        Config.getFile("daemon.properties").setValue("authentication.token", token.toString());
    }
}

