/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.process.childprocess.CreateResponse;
import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.ChildProcesses;
import com.gamedash.daemon.process.childprocess.reference.References;
import com.gamedash.daemon.process.childprocess.terminal.generic.Generic;
import com.gamedash.daemon.process.childprocess.terminal.io.OutputItem;
import com.gamedash.daemon.process.childprocess.terminal.pty.Pty;
import com.gamedash.daemon.relay.Message;
import com.gamedash.daemon.relay.client.channel.Channel;
import com.gamedash.daemon.relay.client.channel.Channels;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;

public class Create
extends Route<CreateResponse> {
    private static Logger logger = LoggerFactory.getLogger(Create.class);

    public Create(Request request, Response response) {
        super(request, response);
    }

    @Override
    public CreateResponse execute() throws Exception {
        String executable = this.getParameters().get("executable").getValue();
        List<String> args = this.getParameters().get("args").getList();
        Boolean await = this.getParameters().exists("await") ? this.getParameters().get("await").getValue(Boolean.class) : Boolean.valueOf(false);
        File workingDirectory = this.getWorkingDirectory();
        String referenceName = this.getParameters().exists("reference") ? this.getParameters().get("reference").getValue() : null;
        ArrayList relayChannelNames = this.getParameters().exists("relayChannels") ? this.getParameters().get("relayChannels").getList() : new ArrayList();
        ArrayList outputFilters = this.getParameters().exists("outputFilters") ? this.getParameters().get("outputFilters").getList() : new ArrayList();
        Map<String, String> environmentVariables = this.getEnvironmentVariables();
        Integer cpuLimitPercentage = this.getParameters().exists("cpuLimitPercentage") ? this.getParameters().get("cpuLimitPercentage").getValue(Integer.class) : null;
        Boolean useShell = this.getParameters().exists("useShell") ? this.getParameters().get("useShell").getValue(Boolean.class) : null;
        ChildProcess process = ChildProcesses.create(this.getTerminalClass());
        if (referenceName != null) {
            process.getReferences();
            if (References.exists(referenceName)) {
                throw new Exception("Reference with name " + referenceName + " already exists");
            }
            process.getReferences().create(referenceName);
        }
        if (!await.booleanValue()) {
            process.setShouldReportCrashes(true);
        }
        if (workingDirectory != null) {
            process.setWorkingDirectory(workingDirectory);
        }
        if (environmentVariables != null) {
            process.setEnvironmentVariables(environmentVariables);
        }
        if (useShell != null) {
            process.setUseShell(useShell);
        }
        process.onExit(() -> logger.debug("Process " + process.getId() + " exited"));
        relayChannelNames.forEach(channelName -> {
            try {
                Channel channel = Channels.get(channelName);
                process.getIo().onOutputEvent(outputItem -> {
                    try {
                        channel.broadcast(new Message<OutputItem>("process.output", outputItem));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        if (outputFilters != null) {
            process.getIo().onOutputEvent(outputItem -> {
                if (outputItem.isError()) {
                    return;
                }
                try {
                    ArrayList<String> matches = new ArrayList<String>();
                    for (String filter : outputFilters) {
                        Matcher matcher = Pattern.compile(filter).matcher(outputItem.getValue());
                        while (matcher.find()) {
                            matches.add(matcher.group(1));
                        }
                    }
                    if (matches.size() > 0) {
                        new Thread(() -> {
                            try {
                                ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/process/childprocess/" + process.getId() + "/io/output/filtered");
                                query.getParameters().create("value").setValue(outputItem.getValue());
                                query.post();
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage());
                            }
                        }).run();
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            });
        }
        process.spawn(executable, args.toArray(new String[args.size()]));
        if (cpuLimitPercentage != null) {
            process.getCpuLimiter().limit(cpuLimitPercentage);
        }
        CreateResponse response = new CreateResponse(process.getId());
        if (await.booleanValue()) {
            process.waitFor();
            process.getIo().getOutputItems().forEach(response::addOutput);
        }
        return response;
    }

    private Map<String, String> getEnvironmentVariables() throws Exception {
        String jsonString;
        String string = jsonString = this.getParameters().exists("environmentVariables") ? this.getParameters().get("environmentVariables").getValue() : null;
        if (jsonString != null) {
            Gson gson = new Gson();
            return gson.fromJson(jsonString, Map.class);
        }
        return null;
    }

    private File getWorkingDirectory() throws Exception {
        return this.getParameters().exists("workingDirectory") ? new File(this.getParameters().get("workingDirectory").getValue()) : null;
    }

    private Class getTerminalClass() throws Exception {
        if (this.getParameters().exists("terminal") && this.getParameters().get("terminal").getValue().equalsIgnoreCase("pty")) {
            return Pty.class;
        }
        return Generic.class;
    }

    @Override
    protected String[] getRequiredParameters() {
        return new String[]{"executable", "args"};
    }
}

