/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunk;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunks;
import java.io.InputStream;
import java.util.UUID;
import spark.Request;
import spark.Response;

public class UploadChunk
extends Route<String> {
    private InputStream inputStream;

    public UploadChunk(Request request, Response response, InputStream inputStream) {
        super(request, response);
        this.inputStream = inputStream;
    }

    @Override
    public String execute() throws Exception {
        UUID sessionId = UUID.fromString(this.getParameters().get("sessionId").getValue());
        long chunkId = this.getParameters().get("chunkId").getValue(Long.class);
        if (!Sessions.exists(sessionId)) {
            throw new Exception("Session does not exist");
        }
        Session session = Sessions.get(sessionId);
        Chunks chunks = session.getChunks();
        if (chunks.exists(chunkId)) {
            throw new Exception("Chunk with id " + chunkId + " already exists");
        }
        Chunk chunk = chunks.create(chunkId);
        chunk.write(this.inputStream);
        if (chunks.receiveIsComplete()) {
            chunks.merge();
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"sessionId", "chunkId"};
    }
}

