/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import spark.Request;
import spark.Response;

public class Serve
extends Route<Response> {
    public Serve(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Response execute() throws Exception {
        File file = File.fromBase64(this.getParameters().get("path").getValue());
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File does not exist");
        }
        try (ServletOutputStream outputStream = this.response.raw().getOutputStream();
             FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.transferTo(outputStream);
            outputStream.flush();
        }
        return this.response;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

