/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import spark.Request;
import spark.Response;

public class Copy
extends Route<String> {
    public Copy(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        com.gamedash.daemon.fileSystem.File origin = com.gamedash.daemon.fileSystem.File.fromBase64(this.getParameters().get("origin").getValue());
        com.gamedash.daemon.fileSystem.File destination = com.gamedash.daemon.fileSystem.File.fromBase64(this.getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isFile()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        if (destination.exists() && !destination.isFile()) {
            throw new IOException("Destination file already exists, but is not a file");
        }
        FileUtils.copyFile((File)origin, destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

