/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.ErrorBody;
import com.google.gson.Gson;

public class ExceptionHandler<T extends Exception> {
    private Class<T> type;
    private int code = 400;
    private Gson gson = new Gson();

    public ExceptionHandler(Class<T> type) {
        this.type = type;
    }

    public ExceptionHandler(Class<T> type, int code) {
        this.type = type;
        this.code = code;
    }

    public void register() {
        ApiServer.getService().exception(this.type, (exception, request, response) -> {
            response.status(this.getCode());
            response.type("application/json");
            response.body(this.gson.toJson(new ErrorBody(exception.getMessage(), exception.getStackTrace())));
        });
    }

    public int getCode() {
        return this.code;
    }
}

