/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.logging;

import java.util.Map;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.logging.LogLevel;
import org.apache.mina.util.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingFilter
extends IoFilterAdapter {
    private final Map<IoEventType, LogLevel> logSettings = new CopyOnWriteMap<IoEventType, LogLevel>();
    private final String name;
    private final Logger logger;

    public LoggingFilter() {
        this(LoggingFilter.class.getName());
    }

    public LoggingFilter(Class<?> clazz) {
        this(clazz.getName());
    }

    public LoggingFilter(String name) {
        if (name == null) {
            throw new NullPointerException("name should not be null");
        }
        this.name = name;
        this.logger = LoggerFactory.getLogger(name);
        this.setLogLevel(IoEventType.EXCEPTION_CAUGHT, LogLevel.WARN);
        this.setLogLevel(IoEventType.MESSAGE_RECEIVED, LogLevel.INFO);
        this.setLogLevel(IoEventType.MESSAGE_SENT, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_CLOSED, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_CREATED, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_IDLE, LogLevel.INFO);
        this.setLogLevel(IoEventType.SESSION_OPENED, LogLevel.INFO);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.getLogLevel(IoEventType.EXCEPTION_CAUGHT).log(this.logger, "EXCEPTION: ", cause);
        nextFilter.exceptionCaught(session, cause);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.log(IoEventType.MESSAGE_RECEIVED, "RECEIVED: {}", message);
        nextFilter.messageReceived(session, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.log(IoEventType.MESSAGE_SENT, "SENT: {}", writeRequest.getMessage());
        nextFilter.messageSent(session, writeRequest);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.log(IoEventType.SESSION_CLOSED, "CLOSED", null);
        nextFilter.sessionClosed(session);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.log(IoEventType.SESSION_CREATED, "CREATED", null);
        nextFilter.sessionCreated(session);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.log(IoEventType.SESSION_IDLE, "IDLE: {}", status);
        nextFilter.sessionIdle(session, status);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.log(IoEventType.SESSION_OPENED, "OPENED", null);
        nextFilter.sessionOpened(session);
    }

    protected void log(IoEventType eventType, String format, Object arg) {
        this.getLogLevel(eventType).log(this.logger, format, arg);
    }

    public void setExceptionCaughtLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.EXCEPTION_CAUGHT, logLevel);
    }

    public void setMessageReceivedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.MESSAGE_RECEIVED, logLevel);
    }

    public void setMessageSentLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.MESSAGE_SENT, logLevel);
    }

    public void setSessionClosedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_CLOSED, logLevel);
    }

    public void setSessionCreatedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_CREATED, logLevel);
    }

    public void setSessionIdleLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_IDLE, logLevel);
    }

    public void setSessionOpenedLogLevel(LogLevel logLevel) {
        this.setLogLevel(IoEventType.SESSION_OPENED, logLevel);
    }

    public void setLogLevel(IoEventType eventType, LogLevel logLevel) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (logLevel == null) {
            throw new NullPointerException("logLevel");
        }
        this.logSettings.put(eventType, logLevel);
    }

    public LogLevel getLogLevel(IoEventType eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        return this.logSettings.get((Object)eventType);
    }

    public LogLevel getExceptionCaughtLogLevel() {
        return this.getLogLevel(IoEventType.EXCEPTION_CAUGHT);
    }

    public LogLevel getMessageReceivedLogLevel() {
        return this.getLogLevel(IoEventType.MESSAGE_RECEIVED);
    }

    public LogLevel getMessageSentLogLevel() {
        return this.getLogLevel(IoEventType.MESSAGE_SENT);
    }

    public LogLevel getSessionClosedLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_CLOSED);
    }

    public LogLevel getSessionCreatedLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_CREATED);
    }

    public LogLevel getSessionIdleLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_IDLE);
    }

    public LogLevel getSessionOpenedLogLevel() {
        return this.getLogLevel(IoEventType.SESSION_OPENED);
    }
}

