/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client.input.parameter;

import com.schokkerit.restapi.client.input.parameter.Parameter;
import com.schokkerit.restapi.client.input.parameter.ParameterException;
import java.util.ArrayList;
import java.util.List;

public class Parameters {
    private final List<Parameter<?>> parameters = new ArrayList();

    public List<Parameter<?>> getAll() {
        return this.parameters;
    }

    public Parameter<String> create(String name, String value) {
        return this.createGeneric(name, value);
    }

    public Parameter<Integer> create(String name, Integer value) {
        return this.createGeneric(name, value);
    }

    public Parameter<Boolean> create(String name, Boolean value) {
        return this.createGeneric(name, value);
    }

    private <T> Parameter<T> createGeneric(String name, T value) {
        if (this.exists(name)) {
            throw new ParameterException("Parameter " + name + " already exists");
        }
        Parameter<T> parameter = new Parameter<T>(name, value);
        this.parameters.add(parameter);
        return parameter;
    }

    public void delete(String name) {
        for (Parameter<?> parameter : this.getAll()) {
            if (!parameter.getName().equals(name)) continue;
            this.getAll().remove(parameter);
            return;
        }
    }

    public Parameter<?> get(String name) {
        for (Parameter<?> parameter : this.getAll()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public boolean exists(String name) {
        for (Parameter<?> parameter : this.getAll()) {
            if (!parameter.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

