/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client.input;

import com.schokkerit.restapi.client.input.transformer.BooleanToStringTransformer;
import com.schokkerit.restapi.client.input.transformer.IntegerToStringTransformer;
import com.schokkerit.restapi.client.input.transformer.Transformer;
import java.util.HashMap;

public class Value<T> {
    private final String name;
    private T value;

    public Value(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setValue(Object value, Transformer<T> transformer) {
        this.setValue(transformer.transform(value));
    }

    public String transformToString() {
        HashMap transformerMap = new HashMap<Class<?>, Transformer<String>>(){
            {
                this.put(Boolean.class, new BooleanToStringTransformer());
                this.put(Integer.class, new IntegerToStringTransformer());
            }
        };
        T value = this.getValue();
        Transformer transformer = (Transformer)transformerMap.get(value.getClass());
        if (transformer != null) {
            return (String)transformer.transform(value);
        }
        return value.toString();
    }
}

