/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.handler.FramedResponseStreamHandler;
import com.github.dockerjava.netty.handler.HttpConnectionHijackHandler;
import com.github.dockerjava.netty.handler.HttpRequestProvider;
import com.github.dockerjava.netty.handler.HttpResponseHandler;
import com.github.dockerjava.netty.handler.HttpResponseStreamHandler;
import com.github.dockerjava.netty.handler.JsonResponseCallbackHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.DuplexChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class NettyInvocationBuilder
implements InvocationBuilder {
    private ChannelProvider channelProvider;
    private String resource;
    private Map<String, String> headers = new HashMap<String, String>();
    private final ObjectMapper objectMapper;

    @Deprecated
    public NettyInvocationBuilder(ChannelProvider channelProvider, String resource) {
        this(DefaultDockerClientConfig.createDefaultConfigBuilder().build().getObjectMapper(), channelProvider, resource);
    }

    public NettyInvocationBuilder(ObjectMapper objectMapper, ChannelProvider channelProvider, String resource) {
        this.objectMapper = objectMapper;
        this.channelProvider = channelProvider;
        this.resource = resource;
    }

    @Override
    public InvocationBuilder accept(MediaType mediaType) {
        return this.header(HttpHeaderNames.ACCEPT.toString(), mediaType.getMediaType());
    }

    @Override
    public NettyInvocationBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    @Override
    public void delete() {
        HttpRequestProvider requestProvider = this.httpDeleteRequestProvider();
        try (ResponseCallback callback = new ResponseCallback();){
            HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
            DuplexChannel channel = this.getChannel();
            channel.pipeline().addLast(responseHandler);
            this.sendRequest(requestProvider, channel);
            callback.awaitResult();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void get(ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        DuplexChannel channel = this.getChannel();
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(TypeReference<T> typeReference) {
        try (ResponseCallback callback = new ResponseCallback();){
            this.get(typeReference, callback);
            Object t = callback.awaitResult();
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(this.objectMapper, typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(new JsonObjectDecoder(0x300000));
        channel.pipeline().addLast(jsonResponseHandler);
        this.sendRequest(requestProvider, channel);
    }

    private DuplexChannel getChannel() {
        return this.channelProvider.getChannel();
    }

    private HttpRequestProvider httpDeleteRequestProvider() {
        return this::prepareDeleteRequest;
    }

    private HttpRequestProvider httpGetRequestProvider() {
        return this::prepareGetRequest;
    }

    private HttpRequestProvider httpPostRequestProvider(Object entity) {
        return uri -> this.preparePostRequest(uri, entity);
    }

    private HttpRequestProvider httpPutRequestProvider(Object entity) {
        return uri -> this.preparePutRequest(uri, entity);
    }

    @Override
    public InputStream post(Object entity) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        InvocationBuilder.AsyncResultCallback<InputStream> callback = new InvocationBuilder.AsyncResultCallback<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler(callback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
        return callback.awaitResult();
    }

    @Override
    public void post(Object entity, final InputStream stdin, ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        final DuplexChannel channel = this.getChannel();
        channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> resultCallback.onComplete()));
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpConnectionHijackHandler hijackHandler = new HttpConnectionHijackHandler(responseHandler);
        HttpClientCodec httpClientCodec = channel.pipeline().get(HttpClientCodec.class);
        channel.pipeline().addLast(new HttpClientUpgradeHandler(httpClientCodec, hijackHandler, Integer.MAX_VALUE));
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
        hijackHandler.awaitUpgrade();
        if (stdin != null) {
            new Thread(new Runnable(){

                private int read(InputStream is, byte[] buf) {
                    try {
                        return is.read(buf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void run() {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = this.read(stdin, buffer)) != -1) {
                        channel.writeAndFlush(Unpooled.copiedBuffer(buffer, 0, read));
                    }
                    channel.shutdownOutput();
                }
            }).start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(Object entity, TypeReference<T> typeReference) {
        try (ResponseCallback callback = new ResponseCallback();){
            this.post(entity, typeReference, callback);
            Object t = callback.awaitResult();
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(this.objectMapper, typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(new JsonObjectDecoder(0x300000));
        channel.pipeline().addLast(jsonResponseHandler);
        this.sendRequest(requestProvider, channel);
    }

    private HttpRequest prepareDeleteRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, uri);
        this.setDefaultHeaders(request);
        return request;
    }

    private FullHttpRequest prepareGetRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
        this.setDefaultHeaders(request);
        return request;
    }

    private HttpRequest preparePostRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.POST);
    }

    private HttpRequest preparePutRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.PUT);
    }

    private HttpRequest prepareEntityRequest(String uri, Object entity, HttpMethod httpMethod) {
        DefaultHttpRequest request = null;
        if (entity != null) {
            byte[] bytes;
            DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            try {
                bytes = this.objectMapper.writeValueAsBytes(entity);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            fullRequest.content().clear().writeBytes(Unpooled.copiedBuffer(bytes));
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
            request = fullRequest;
        } else {
            request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        this.setDefaultHeaders(request);
        return request;
    }

    private void sendRequest(HttpRequestProvider requestProvider, Channel channel) {
        ChannelFuture channelFuture = channel.writeAndFlush(requestProvider.getHttpRequest(this.resource));
        channelFuture.addListener(future -> {});
    }

    private void setDefaultHeaders(HttpRequest request) {
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.headers().set((CharSequence)entry.getKey(), (Object)entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        try (ResponseCallback callback = new ResponseCallback();){
            this.post(typeReference, callback, body);
            Object t = callback.awaitResult();
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(this.objectMapper, typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChunkedWriteHandler());
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(new JsonObjectDecoder(0x300000));
        channel.pipeline().addLast(jsonResponseHandler);
        this.postChunkedStreamRequest(requestProvider, channel, body);
    }

    @Override
    public void postStream(InputStream body) {
        SkipResultCallback resultCallback = new SkipResultCallback();
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChunkedWriteHandler());
        channel.pipeline().addLast(responseHandler);
        this.postChunkedStreamRequest(requestProvider, channel, body);
        try {
            resultCallback.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void postChunkedStreamRequest(HttpRequestProvider requestProvider, Channel channel, InputStream body) {
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        channel.write(request);
        channel.write(new ChunkedStream(new BufferedInputStream(body, 0x100000), 0x100000));
        channel.write(LastHttpContent.EMPTY_LAST_CONTENT);
        channel.flush();
    }

    @Override
    public InputStream get() {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        InvocationBuilder.AsyncResultCallback<InputStream> resultCallback = new InvocationBuilder.AsyncResultCallback<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler(resultCallback);
        channel.pipeline().addLast(responseHandler);
        channel.pipeline().addLast(streamHandler);
        this.sendRequest(requestProvider, channel);
        return resultCallback.awaitResult();
    }

    @Override
    public void put(InputStream body, MediaType mediaType) {
        HttpRequestProvider requestProvider = this.httpPutRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        try (ResponseCallback resultCallback = new ResponseCallback();){
            HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
            channel.pipeline().addLast(new ChunkedWriteHandler());
            channel.pipeline().addLast(responseHandler);
            HttpRequest request = requestProvider.getHttpRequest(this.resource);
            if (request instanceof FullHttpRequest) {
                throw new DockerClientException("fatal: request is instance of FullHttpRequest");
            }
            request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            request.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType.getMediaType());
            channel.write(request);
            channel.write(new ChunkedStream(new BufferedInputStream(body, 0x100000)));
            channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            resultCallback.awaitResult();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class SkipResultCallback
    extends ResultCallbackTemplate<ResponseCallback<Void>, Void> {
        @Override
        public void onNext(Void object) {
        }
    }

    public class ResponseCallback<T>
    extends ResultCallbackTemplate<ResponseCallback<T>, T> {
        private T result = null;

        public T awaitResult() {
            try {
                this.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.result;
        }

        @Override
        public void onNext(T object) {
            this.result = object;
        }
    }
}

