/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.hardware.processor;

import com.gamedash.daemon.system.hardware.processor.Processor;
import java.util.ArrayList;
import java.util.List;

public class Processors {
    private static volatile List<Processor> processors = new ArrayList<Processor>();

    public static List<Processor> getAll() {
        ArrayList<Processor> processors = new ArrayList<Processor>();
        for (int id = 0; id < Processors.count(); ++id) {
            processors.add(Processors.get(id));
        }
        return processors;
    }

    public static int count() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static Processor get(int id) {
        for (Processor processor : processors) {
            if (processor.getId() != id) continue;
            return processor;
        }
        Processor processor = new Processor(id);
        processors.add(processor);
        return processor;
    }

    public static long toMask(List<Processor> processors) {
        long mask = 0L;
        for (Processor processor : Processors.getAll()) {
            mask |= (long)((processors.contains(processor) ? 1 : 0) << processor.getId());
        }
        return mask;
    }
}

