/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.resource.limit;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.resource.limit.IResourceLimitEnforcementManager;
import com.gamedash.daemon.process.resource.limit.ResourceLimitException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceLimitEnforcementManager
implements IResourceLimitEnforcementManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceLimitEnforcementManager.class);
    private IProcess process;
    private Thread thread;
    private boolean running = false;
    private int interval = 30000;

    public AbstractResourceLimitEnforcementManager(IProcess process) {
        this.process = process;
    }

    @Override
    public void enforce() throws Exception {
        this.process.enforceResourceLimits();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            throw new ResourceLimitException("Enforcement manage is already running");
        }
        this.thread = new Thread(() -> {
            try {
                while (true) {
                    this.enforce();
                    Thread.sleep(this.getInterval());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ProcessNotFoundException ignored) {
                this.stop();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        this.thread.setName(String.format("Resource limit enforcement manager for process %d", this.process.getId()));
        this.thread.start();
        this.setIsRunning(true);
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            throw new ResourceLimitException("Enforcement manager is not running");
        }
        this.thread.interrupt();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setIsRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public int getInterval() {
        return this.interval;
    }
}

