/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.windows;

import com.gamedash.daemon.exception.NotImplementedException;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcess;
import com.gamedash.daemon.platform.windows.process.childProcess.io.WindowsPlatformChildProcessOutputItem;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.io.AbstractIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IQueuedInputStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsTerminalIo
extends AbstractIo
implements IIo,
IQueuedInputStreamListener {
    private static final Logger logger = LoggerFactory.getLogger(WindowsTerminalIo.class);

    WindowsTerminalIo(ChildProcess childProcess) throws Exception {
        super(childProcess);
    }

    @Override
    public void write(String value) throws Exception {
        this.childProcess.getApi(WindowsPlatformChildProcess.class).sendInput(value);
    }

    @Override
    public void waitFor() throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void listen() {
        if (this.isListening()) {
            throw new ProcessException("Already listening to io");
        }
        this.setIsListening(true);
        this.getOutputQueueManager().createPool(1);
        Thread thread = new Thread(() -> {
            try {
                this.childProcess.getApi(WindowsPlatformChildProcess.class).getIo().onOutput((WindowsPlatformChildProcessOutputItem windowsOutputItem) -> {
                    OutputItem outputItem = new OutputItem(windowsOutputItem.getValue(), windowsOutputItem.isError());
                    this.getOutputQueueManager().queueOutputItem(outputItem);
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        thread.setName(String.format("Windows terminal IO listener for process %d", this.childProcess.getId()));
        thread.start();
    }

    @Override
    public void destroy() throws InterruptedException {
        this.getOutputQueueManager().stopWorkersGracefully();
    }
}

