/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.windows;

import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcess;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcessUser;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcesses;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.AbstractTerminal;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.windows.WindowsTerminalIo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class WindowsTerminal
extends AbstractTerminal
implements ITerminal {
    private static final String cmdPath = "C:\\Windows\\System32\\cmd.exe";
    private final ChildProcess childProcess;
    private final IIo io;
    private WindowsPlatformChildProcess windowsChildProcess;

    public WindowsTerminal(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.io = new WindowsTerminalIo(this.childProcess);
    }

    @Override
    public void spawn(String[] inputArgs) throws Exception {
        String executable = inputArgs[0];
        String[] args = inputArgs.length > 1 ? Arrays.copyOfRange(inputArgs, 1, inputArgs.length) : new String[]{};
        this.windowsChildProcess = WindowsPlatformChildProcesses.create();
        if (this.childProcess.hasSystemUser()) {
            this.windowsChildProcess.setUser(new WindowsPlatformChildProcessUser(this.childProcess.getSystemUser()));
        }
        if (this.childProcess.hasWorkingDirectory().booleanValue()) {
            this.windowsChildProcess.setWorkingDirectory(this.childProcess.getWorkingDirectory());
        }
        this.getIo().listen();
        this.listenForExit();
        this.windowsChildProcess.spawn(cmdPath, ArrayUtils.addAll(new String[]{"/d", "/s", "/c", executable}, args));
    }

    @Override
    public boolean hasExited() {
        return this.windowsChildProcess != null && this.windowsChildProcess.hasExited();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        this.windowsChildProcess.stop();
    }

    @Override
    public List<ProcessHandle> getDescendants() {
        return new ArrayList<ProcessHandle>();
    }

    @Override
    public int getExitCode() {
        return this.windowsChildProcess.getExitCode();
    }

    @Override
    public boolean isRunning() {
        return this.windowsChildProcess != null && !this.windowsChildProcess.hasExited();
    }

    @Override
    public Integer getId() {
        return this.windowsChildProcess != null ? this.windowsChildProcess.getId() : null;
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.windowsChildProcess);
    }

    private void listenForExit() {
        this.windowsChildProcess.onExit(this::handleExit);
    }
}

