/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.pty;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.AbstractTerminal;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.pty.PtyTerminalIo;
import com.pty4j.PtyProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtyTerminal
extends AbstractTerminal
implements ITerminal {
    public static final Logger logger = LoggerFactory.getLogger(PtyTerminal.class);
    private final ChildProcess childProcess;
    private final IIo io;
    private int id;
    private PtyProcess api;

    public PtyTerminal(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.io = new PtyTerminalIo(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        Map<String, String> environmentVariables = this.childProcess.getEnvironmentVariables();
        this.api = PtyProcess.exec(args, environmentVariables, this.childProcess.hasWorkingDirectory() != false ? this.childProcess.getWorkingDirectory().toString() : null);
        this.id = this.api.getPid();
        this.getIo().listen();
        if (this.api.isAlive()) {
            CompletableFuture<Process> onExit = this.api.onExit();
            onExit.thenAccept(_handle -> {
                Thread thread = new Thread(this::handleExit);
                thread.setName(String.format("PTY terminal exit listener for process %d", this.childProcess.getId()));
                thread.start();
            });
        } else {
            this.handleExit();
        }
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        List<ProcessHandle> descendants = this.getDescendants();
        if (this.supportsNormalTermination()) {
            this.api.destroy();
            if (descendants.size() > 0) {
                descendants.forEach(ProcessHandle::destroy);
            }
            this.waitForExit(5);
            this.api.destroyForcibly();
            if (descendants.size() > 0) {
                descendants.forEach(ProcessHandle::destroyForcibly);
            }
        } else {
            this.api.destroyForcibly();
        }
        this.waitForExit();
    }

    @Override
    public List<ProcessHandle> getDescendants() {
        return new ArrayList<ProcessHandle>();
    }

    @Override
    public int getExitCode() {
        return this.api.exitValue();
    }

    @Override
    public boolean isRunning() {
        return this.api.isRunning();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }

    public boolean supportsNormalTermination() {
        return true;
    }
}

