/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.registry.store.file;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.fileSystem.file.filters.RootDirectoryFileFilter;
import com.gamedash.daemon.process.childProcess.registry.ChildProcessRegistryEntry;
import com.gamedash.daemon.process.childProcess.registry.ChildProcessRegistryEntryAlreadyExistsException;
import com.gamedash.daemon.process.childProcess.registry.ChildProcessRegistryEntryNotFoundException;
import com.gamedash.daemon.process.childProcess.registry.store.IChildProcessRegistryStore;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessRegistryFileStore
implements IChildProcessRegistryStore {
    public static final Logger logger = LoggerFactory.getLogger(Application.class);
    private static final Gson gson = new Gson();
    private final File directory = ChildProcessRegistryFileStore.resolvePath("child-processes").toFile();

    public ChildProcessRegistryFileStore() {
        try {
            this.initializeFileSystem();
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    @Override
    public List<ChildProcessRegistryEntry> getEntries() {
        RootDirectoryFileFilter filter = new RootDirectoryFileFilter(this.directory);
        List files = (List)FileUtils.listFiles(this.directory, filter, filter);
        for (File file2 : files) {
            System.out.println("File " + file2.getPath());
        }
        return files.stream().map(file -> {
            try {
                return this.createEntryFromFile((File)file);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void addEntries(ChildProcessRegistryEntry[] entries) throws Exception {
        for (ChildProcessRegistryEntry entry : entries) {
            try {
                this.addEntry(entry);
            }
            catch (ChildProcessRegistryEntryAlreadyExistsException e) {
                if (!DevelopmentMode.isEnabled()) continue;
                logger.info(MessageFormat.format("Child process {0,number,#} is already registered", entry.getId()));
            }
        }
    }

    @Override
    public void addEntry(ChildProcessRegistryEntry entry) throws IOException {
        File file = this.resolvePathForProcess(entry.getId()).toFile();
        if (!file.createNewFile()) {
            throw new ChildProcessRegistryEntryAlreadyExistsException(MessageFormat.format("Entry for process {0,number,#} already exists", entry.getId()));
        }
    }

    @Override
    public void addEntryIfNotFound(ChildProcessRegistryEntry entry) throws IOException {
        try {
            this.addEntry(entry);
        }
        catch (ChildProcessRegistryEntryAlreadyExistsException childProcessRegistryEntryAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public ChildProcessRegistryEntry getEntry(int id) {
        if (!this.resolvePathForProcess(id).toFile().exists()) {
            return null;
        }
        return ChildProcessRegistryEntry.get(id);
    }

    @Override
    public void removeEntry(int id) {
        File file = this.resolvePathForProcess(id).toFile();
        if (!file.exists()) {
            throw new ChildProcessRegistryEntryNotFoundException(MessageFormat.format("Entry for process {0,number,#} not found", id));
        }
        file.delete();
    }

    @Override
    public void clearEntries() {
        List<ChildProcessRegistryEntry> entries = this.getEntries();
        for (ChildProcessRegistryEntry entry : entries) {
            this.removeEntry(entry.getId());
        }
    }

    private void initializeFileSystem() throws Exception {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException(MessageFormat.format("Could not create directory", this.directory.getPath()));
        }
    }

    private ChildProcessRegistryEntry createEntryFromFile(File file) throws IOException {
        return ChildProcessRegistryEntry.get(Integer.parseInt(file.getName().split("\\.")[0]));
    }

    private Path resolvePathForProcess(Integer id) {
        return Paths.get(this.directory.getPath(), id.toString());
    }

    private static Path resolvePath(String path) {
        return ChildProcessRegistryFileStore.resolvePath(Paths.get(path, new String[0]));
    }

    private static Path resolvePath(Path path) {
        Path rootPath = Paths.get(FileSystem.getRootDirectory().toString(), new String[0]);
        return rootPath.resolve(path);
    }
}

